/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.util.Arrays;
import org.stellar.sdk.AbstractTransaction;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Network;
import org.stellar.sdk.Transaction;
import org.stellar.sdk.xdr.DecoratedSignature;
import org.stellar.sdk.xdr.EnvelopeType;
import org.stellar.sdk.xdr.FeeBumpTransaction;
import org.stellar.sdk.xdr.FeeBumpTransactionEnvelope;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.TransactionEnvelope;
import org.stellar.sdk.xdr.TransactionSignaturePayload;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;
import shadow.com.google.common.collect.Lists;

public class FeeBumpTransaction
extends AbstractTransaction {
    private final long mFee;
    private final String mFeeAccount;
    private final Transaction mInner;

    FeeBumpTransaction(AccountConverter accountConverter, String feeAccount, long fee, Transaction innerTransaction) {
        super(accountConverter, innerTransaction.getNetwork());
        this.mFeeAccount = Preconditions.checkNotNull(feeAccount, "feeAccount cannot be null");
        this.mInner = Preconditions.checkNotNull(innerTransaction, "innerTransaction cannot be null");
        this.mFee = fee;
    }

    public long getFee() {
        return this.mFee;
    }

    public String getFeeAccount() {
        return this.mFeeAccount;
    }

    public Transaction getInnerTransaction() {
        return this.mInner;
    }

    public static FeeBumpTransaction fromFeeBumpTransactionEnvelope(AccountConverter accountConverter, FeeBumpTransactionEnvelope envelope, Network network) {
        Transaction inner = Transaction.fromV1EnvelopeXdr(accountConverter, envelope.getTx().getInnerTx().getV1(), network);
        String feeAccount = accountConverter.decode(envelope.getTx().getFeeSource());
        long fee = envelope.getTx().getFee().getInt64();
        FeeBumpTransaction feeBump = new FeeBumpTransaction(accountConverter, feeAccount, fee, inner);
        feeBump.mSignatures.addAll(Arrays.asList(envelope.getSignatures()));
        return feeBump;
    }

    public static FeeBumpTransaction fromFeeBumpTransactionEnvelope(FeeBumpTransactionEnvelope envelope, Network network) {
        return FeeBumpTransaction.fromFeeBumpTransactionEnvelope(AccountConverter.disableMuxed(), envelope, network);
    }

    private org.stellar.sdk.xdr.FeeBumpTransaction toXdr() {
        org.stellar.sdk.xdr.FeeBumpTransaction xdr = new org.stellar.sdk.xdr.FeeBumpTransaction();
        xdr.setExt(new FeeBumpTransaction.FeeBumpTransactionExt());
        xdr.getExt().setDiscriminant(0);
        Int64 xdrFee = new Int64();
        xdrFee.setInt64(this.mFee);
        xdr.setFee(xdrFee);
        xdr.setFeeSource(this.accountConverter.encode(this.mFeeAccount));
        FeeBumpTransaction.FeeBumpTransactionInnerTx innerXDR = new FeeBumpTransaction.FeeBumpTransactionInnerTx();
        innerXDR.setDiscriminant(EnvelopeType.ENVELOPE_TYPE_TX);
        innerXDR.setV1(this.mInner.toEnvelopeXdr().getV1());
        xdr.setInnerTx(innerXDR);
        return xdr;
    }

    @Override
    public byte[] signatureBase() {
        TransactionSignaturePayload.TransactionSignaturePayloadTaggedTransaction taggedTransaction = new TransactionSignaturePayload.TransactionSignaturePayloadTaggedTransaction();
        taggedTransaction.setDiscriminant(EnvelopeType.ENVELOPE_TYPE_TX_FEE_BUMP);
        taggedTransaction.setFeeBump(this.toXdr());
        return FeeBumpTransaction.getTransactionSignatureBase(taggedTransaction, this.mNetwork);
    }

    @Override
    public TransactionEnvelope toEnvelopeXdr() {
        TransactionEnvelope xdr = new TransactionEnvelope();
        FeeBumpTransactionEnvelope feeBumpEnvelope = new FeeBumpTransactionEnvelope();
        xdr.setDiscriminant(EnvelopeType.ENVELOPE_TYPE_TX_FEE_BUMP);
        feeBumpEnvelope.setTx(this.toXdr());
        DecoratedSignature[] signatures = new DecoratedSignature[this.mSignatures.size()];
        signatures = this.mSignatures.toArray(signatures);
        feeBumpEnvelope.setSignatures(signatures);
        xdr.setFeeBump(feeBumpEnvelope);
        return xdr;
    }

    public int hashCode() {
        return Objects.hashCode(this.mFee, this.mInner, this.mNetwork, this.mFeeAccount, this.mSignatures);
    }

    public boolean equals(Object object) {
        if (!(object instanceof FeeBumpTransaction)) {
            return false;
        }
        FeeBumpTransaction other = (FeeBumpTransaction)object;
        return Objects.equal(this.mFee, other.mFee) && Objects.equal(this.mFeeAccount, other.mFeeAccount) && Objects.equal(this.mInner, other.mInner) && Objects.equal(this.mNetwork, other.mNetwork) && Objects.equal(this.mSignatures, other.mSignatures);
    }

    public static class Builder {
        private final Transaction mInner;
        private Long mBaseFee;
        private String mFeeAccount;
        private final AccountConverter mAccountConverter;

        public Builder(AccountConverter accountConverter, Transaction inner) {
            inner = Preconditions.checkNotNull(inner, "inner cannot be null");
            EnvelopeType txType = inner.toEnvelopeXdr().getDiscriminant();
            this.mAccountConverter = Preconditions.checkNotNull(accountConverter, "accountConverter cannot be null");
            if (inner.toEnvelopeXdr().getDiscriminant() == EnvelopeType.ENVELOPE_TYPE_TX_V0) {
                this.mInner = new Transaction(inner.accountConverter, inner.getSourceAccount(), inner.getFee(), inner.getSequenceNumber(), inner.getOperations(), inner.getMemo(), inner.getTimeBounds(), inner.getNetwork());
                this.mInner.mSignatures = Lists.newArrayList(inner.mSignatures);
            } else {
                this.mInner = inner;
            }
        }

        public Builder(Transaction inner) {
            this(AccountConverter.disableMuxed(), inner);
        }

        public Builder setBaseFee(long baseFee) {
            if (this.mBaseFee != null) {
                throw new RuntimeException("base fee has been already set.");
            }
            if (baseFee < 100L) {
                throw new IllegalArgumentException("baseFee cannot be smaller than the BASE_FEE (100): " + baseFee);
            }
            long innerBaseFee = this.mInner.getFee();
            long numOperations = this.mInner.getOperations().length;
            if (numOperations > 0L) {
                innerBaseFee /= numOperations;
            }
            if (baseFee < innerBaseFee) {
                throw new IllegalArgumentException("base fee cannot be lower than provided inner transaction base fee");
            }
            long maxFee = baseFee * (numOperations + 1L);
            if (maxFee < 0L) {
                throw new IllegalArgumentException("fee overflows 64 bit int");
            }
            this.mBaseFee = maxFee;
            return this;
        }

        public Builder setFeeAccount(String feeAccount) {
            if (this.mFeeAccount != null) {
                throw new RuntimeException("fee account has been already been set.");
            }
            this.mFeeAccount = Preconditions.checkNotNull(feeAccount, "feeAccount cannot be null");
            return this;
        }

        public FeeBumpTransaction build() {
            return new FeeBumpTransaction(this.mAccountConverter, Preconditions.checkNotNull(this.mFeeAccount, "fee account has to be set. you must call setFeeAccount()."), Preconditions.checkNotNull(this.mBaseFee, "base fee has to be set. you must call setBaseFee()."), this.mInner);
        }
    }
}

