/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Operation;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.xdr.CreateAccountOp;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public class CreateAccountOperation
extends Operation {
    private final String destination;
    private final String startingBalance;

    private CreateAccountOperation(String destination, String startingBalance) {
        this.destination = Preconditions.checkNotNull(destination, "destination cannot be null");
        this.startingBalance = Preconditions.checkNotNull(startingBalance, "startingBalance cannot be null");
    }

    public String getStartingBalance() {
        return this.startingBalance;
    }

    public String getDestination() {
        return this.destination;
    }

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        CreateAccountOp op = new CreateAccountOp();
        op.setDestination(StrKey.encodeToXDRAccountId(this.destination));
        Int64 startingBalance = new Int64();
        startingBalance.setInt64(Operation.toXdrAmount(this.startingBalance));
        op.setStartingBalance(startingBalance);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.CREATE_ACCOUNT);
        body.setCreateAccountOp(op);
        return body;
    }

    public int hashCode() {
        return Objects.hashCode(this.destination, this.startingBalance, this.getSourceAccount());
    }

    public boolean equals(Object object) {
        if (!(object instanceof CreateAccountOperation)) {
            return false;
        }
        CreateAccountOperation other = (CreateAccountOperation)object;
        return Objects.equal(this.destination, other.destination) && Objects.equal(this.startingBalance, other.startingBalance) && Objects.equal(this.getSourceAccount(), other.getSourceAccount());
    }

    public static class Builder {
        private final String destination;
        private final String startingBalance;
        private String mSourceAccount;

        Builder(CreateAccountOp op) {
            this.destination = StrKey.encodeStellarAccountId(op.getDestination());
            this.startingBalance = Operation.fromXdrAmount(op.getStartingBalance().getInt64());
        }

        public Builder(String destination, String startingBalance) {
            this.destination = destination;
            this.startingBalance = startingBalance;
        }

        public Builder setSourceAccount(String account) {
            this.mSourceAccount = account;
            return this;
        }

        public CreateAccountOperation build() {
            CreateAccountOperation operation = new CreateAccountOperation(this.destination, this.startingBalance);
            if (this.mSourceAccount != null) {
                operation.setSourceAccount(this.mSourceAccount);
            }
            return operation;
        }
    }
}

