/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.ChangeTrustAsset;
import org.stellar.sdk.Operation;
import org.stellar.sdk.xdr.ChangeTrustOp;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public class ChangeTrustOperation
extends Operation {
    private final ChangeTrustAsset asset;
    private final String limit;

    private ChangeTrustOperation(ChangeTrustAsset asset, String limit) {
        this.asset = Preconditions.checkNotNull(asset, "asset cannot be null");
        this.limit = Preconditions.checkNotNull(limit, "limit cannot be null");
    }

    public ChangeTrustAsset getAsset() {
        return this.asset;
    }

    public String getLimit() {
        return this.limit;
    }

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        ChangeTrustOp op = new ChangeTrustOp();
        op.setLine(this.asset.toXdr());
        Int64 limit = new Int64();
        limit.setInt64(Operation.toXdrAmount(this.limit));
        op.setLimit(limit);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.CHANGE_TRUST);
        body.setChangeTrustOp(op);
        return body;
    }

    public int hashCode() {
        return Objects.hashCode(this.asset, this.limit, this.getSourceAccount());
    }

    public boolean equals(Object object) {
        if (!(object instanceof ChangeTrustOperation)) {
            return false;
        }
        ChangeTrustOperation other = (ChangeTrustOperation)object;
        return Objects.equal(this.asset, other.asset) && Objects.equal(this.limit, other.limit) && Objects.equal(this.getSourceAccount(), other.getSourceAccount());
    }

    public static class Builder {
        private final ChangeTrustAsset asset;
        private final String limit;
        private String mSourceAccount;

        Builder(ChangeTrustOp op) {
            this.asset = ChangeTrustAsset.fromXdr(op.getLine());
            this.limit = Operation.fromXdrAmount(op.getLimit().getInt64());
        }

        public Builder(ChangeTrustAsset asset, String limit) {
            this.asset = Preconditions.checkNotNull(asset, "asset cannot be null");
            this.limit = Preconditions.checkNotNull(limit, "limit cannot be null");
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.mSourceAccount = Preconditions.checkNotNull(sourceAccount, "sourceAccount cannot be null");
            return this;
        }

        public ChangeTrustOperation build() {
            ChangeTrustOperation operation = new ChangeTrustOperation(this.asset, this.limit);
            if (this.mSourceAccount != null) {
                operation.setSourceAccount(this.mSourceAccount);
            }
            return operation;
        }
    }
}

