/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Operation;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.xdr.BeginSponsoringFutureReservesOp;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public class BeginSponsoringFutureReservesOperation
extends Operation {
    private final String sponsoredId;

    private BeginSponsoringFutureReservesOperation(String sponsoredId) {
        this.sponsoredId = sponsoredId;
    }

    public String getSponsoredId() {
        return this.sponsoredId;
    }

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        BeginSponsoringFutureReservesOp op = new BeginSponsoringFutureReservesOp();
        op.setSponsoredID(StrKey.encodeToXDRAccountId(this.sponsoredId));
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.BEGIN_SPONSORING_FUTURE_RESERVES);
        body.setBeginSponsoringFutureReservesOp(op);
        return body;
    }

    public int hashCode() {
        return Objects.hashCode(this.sponsoredId, this.getSourceAccount());
    }

    public boolean equals(Object object) {
        if (!(object instanceof BeginSponsoringFutureReservesOperation)) {
            return false;
        }
        BeginSponsoringFutureReservesOperation other = (BeginSponsoringFutureReservesOperation)object;
        return Objects.equal(this.sponsoredId, other.sponsoredId) && Objects.equal(this.getSourceAccount(), other.getSourceAccount());
    }

    public static class Builder {
        private final String sponsoredId;
        private String mSourceAccount;

        Builder(BeginSponsoringFutureReservesOp op) {
            this.sponsoredId = StrKey.encodeStellarAccountId(op.getSponsoredID());
        }

        public Builder(String sponsoredId) {
            this.sponsoredId = sponsoredId;
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.mSourceAccount = Preconditions.checkNotNull(sourceAccount, "sourceAccount cannot be null");
            return this;
        }

        public BeginSponsoringFutureReservesOperation build() {
            BeginSponsoringFutureReservesOperation operation = new BeginSponsoringFutureReservesOperation(this.sponsoredId);
            if (this.mSourceAccount != null) {
                operation.setSourceAccount(this.mSourceAccount);
            }
            return operation;
        }
    }
}

