/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Operation;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.Util;
import org.stellar.sdk.xdr.AllowTrustOp;
import org.stellar.sdk.xdr.AssetCode;
import org.stellar.sdk.xdr.AssetCode12;
import org.stellar.sdk.xdr.AssetCode4;
import org.stellar.sdk.xdr.AssetType;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.TrustLineFlags;
import org.stellar.sdk.xdr.Uint32;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public class AllowTrustOperation
extends Operation {
    private final String trustor;
    private final String assetCode;
    private final boolean authorize;
    private final boolean authorizeToMaintainLiabilities;

    private AllowTrustOperation(String trustor, String assetCode, boolean authorize, boolean authorizeToMaintainLiabilities) {
        this.trustor = Preconditions.checkNotNull(trustor, "trustor cannot be null");
        this.assetCode = Preconditions.checkNotNull(assetCode, "assetCode cannot be null");
        this.authorize = authorize;
        this.authorizeToMaintainLiabilities = authorizeToMaintainLiabilities;
    }

    public String getTrustor() {
        return this.trustor;
    }

    public String getAssetCode() {
        return this.assetCode;
    }

    public boolean getAuthorize() {
        return this.authorize;
    }

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        AllowTrustOp op = new AllowTrustOp();
        op.setTrustor(StrKey.encodeToXDRAccountId(this.trustor));
        AssetCode asset = new AssetCode();
        if (this.assetCode.length() <= 4) {
            AssetCode4 assetCode4 = new AssetCode4();
            assetCode4.setAssetCode4(Util.paddedByteArray(this.assetCode, 4));
            asset.setDiscriminant(AssetType.ASSET_TYPE_CREDIT_ALPHANUM4);
            asset.setAssetCode4(assetCode4);
        } else {
            AssetCode12 assetCode12 = new AssetCode12();
            assetCode12.setAssetCode12(Util.paddedByteArray(this.assetCode, 12));
            asset.setDiscriminant(AssetType.ASSET_TYPE_CREDIT_ALPHANUM12);
            asset.setAssetCode12(assetCode12);
        }
        op.setAsset(asset);
        Uint32 flag = new Uint32();
        if (this.authorize) {
            flag.setUint32(TrustLineFlags.AUTHORIZED_FLAG.getValue());
        } else if (this.authorizeToMaintainLiabilities) {
            flag.setUint32(TrustLineFlags.AUTHORIZED_TO_MAINTAIN_LIABILITIES_FLAG.getValue());
        } else {
            flag.setUint32(0);
        }
        op.setAuthorize(flag);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.ALLOW_TRUST);
        body.setAllowTrustOp(op);
        return body;
    }

    public int hashCode() {
        return Objects.hashCode(this.getSourceAccount(), this.assetCode, this.authorize, this.authorizeToMaintainLiabilities, this.trustor);
    }

    public boolean equals(Object object) {
        if (!(object instanceof AllowTrustOperation)) {
            return false;
        }
        AllowTrustOperation other = (AllowTrustOperation)object;
        return Objects.equal(this.assetCode, other.assetCode) && Objects.equal(this.authorize, other.authorize) && Objects.equal(this.authorizeToMaintainLiabilities, other.authorizeToMaintainLiabilities) && Objects.equal(this.trustor, other.trustor) && Objects.equal(this.getSourceAccount(), other.getSourceAccount());
    }

    public static class Builder {
        private final String trustor;
        private final String assetCode;
        private final boolean authorize;
        private boolean authorizeToMaintainLiabilities;
        private String mSourceAccount;

        Builder(AllowTrustOp op) {
            this.trustor = StrKey.encodeStellarAccountId(op.getTrustor());
            switch (op.getAsset().getDiscriminant()) {
                case ASSET_TYPE_CREDIT_ALPHANUM4: {
                    this.assetCode = new String(op.getAsset().getAssetCode4().getAssetCode4()).trim();
                    break;
                }
                case ASSET_TYPE_CREDIT_ALPHANUM12: {
                    this.assetCode = new String(op.getAsset().getAssetCode12().getAssetCode12()).trim();
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown asset code");
                }
            }
            int flag = op.getAuthorize().getUint32();
            if (flag == TrustLineFlags.AUTHORIZED_FLAG.getValue()) {
                this.authorize = true;
                this.authorizeToMaintainLiabilities = false;
            } else if (flag == TrustLineFlags.AUTHORIZED_TO_MAINTAIN_LIABILITIES_FLAG.getValue()) {
                this.authorize = false;
                this.authorizeToMaintainLiabilities = true;
            } else {
                if (flag != 0) {
                    throw new IllegalArgumentException("invalid authorize flag " + flag);
                }
                this.authorize = false;
                this.authorizeToMaintainLiabilities = false;
            }
        }

        public Builder(String trustor, String assetCode, boolean authorize) {
            this.trustor = trustor;
            this.assetCode = assetCode;
            this.authorize = authorize;
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.mSourceAccount = sourceAccount;
            return this;
        }

        public AllowTrustOperation build() {
            AllowTrustOperation operation = new AllowTrustOperation(this.trustor, this.assetCode, this.authorize, this.authorizeToMaintainLiabilities);
            if (this.mSourceAccount != null) {
                operation.setSourceAccount(this.mSourceAccount);
            }
            return operation;
        }
    }
}

