/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.Operation;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import shadow.com.google.common.base.Objects;
import shadow.com.google.common.base.Preconditions;

public class AccountMergeOperation
extends Operation {
    private final String destination;

    private AccountMergeOperation(String destination) {
        this.destination = Preconditions.checkNotNull(destination, "destination cannot be null");
    }

    public String getDestination() {
        return this.destination;
    }

    @Override
    Operation.OperationBody toOperationBody(AccountConverter accountConverter) {
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDestination(accountConverter.encode(this.destination));
        body.setDiscriminant(OperationType.ACCOUNT_MERGE);
        return body;
    }

    public int hashCode() {
        return Objects.hashCode(this.destination, this.getSourceAccount());
    }

    public boolean equals(Object object) {
        if (!(object instanceof AccountMergeOperation)) {
            return false;
        }
        AccountMergeOperation other = (AccountMergeOperation)object;
        return Objects.equal(this.destination, other.destination) && Objects.equal(this.getSourceAccount(), other.getSourceAccount());
    }

    public static class Builder {
        private final String destination;
        private String mSourceAccount;

        Builder(AccountConverter accountConverter, Operation.OperationBody op) {
            this.destination = accountConverter.decode(op.getDestination());
        }

        public Builder(String destination) {
            this.destination = destination;
        }

        public Builder setSourceAccount(String sourceAccount) {
            this.mSourceAccount = sourceAccount;
            return this;
        }

        public AccountMergeOperation build() {
            AccountMergeOperation operation = new AccountMergeOperation(this.destination);
            if (this.mSourceAccount != null) {
                operation.setSourceAccount(this.mSourceAccount);
            }
            return operation;
        }
    }
}

