/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.stellar.sdk.AccountConverter;
import org.stellar.sdk.FeeBumpTransaction;
import org.stellar.sdk.KeyPair;
import org.stellar.sdk.Network;
import org.stellar.sdk.Transaction;
import org.stellar.sdk.Util;
import org.stellar.sdk.xdr.DecoratedSignature;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.Signature;
import org.stellar.sdk.xdr.SignatureHint;
import org.stellar.sdk.xdr.TransactionEnvelope;
import org.stellar.sdk.xdr.TransactionSignaturePayload;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import shadow.com.google.common.base.Preconditions;
import shadow.com.google.common.io.BaseEncoding;

public abstract class AbstractTransaction {
    protected final Network mNetwork;
    protected final AccountConverter accountConverter;
    protected List<DecoratedSignature> mSignatures;
    public static final int MIN_BASE_FEE = 100;

    AbstractTransaction(AccountConverter accountConverter, Network network) {
        this.accountConverter = Preconditions.checkNotNull(accountConverter, "accountConverter cannot be null");
        this.mNetwork = Preconditions.checkNotNull(network, "network cannot be null");
        this.mSignatures = new ArrayList<DecoratedSignature>();
    }

    public void sign(KeyPair signer) {
        Preconditions.checkNotNull(signer, "signer cannot be null");
        byte[] txHash = this.hash();
        this.mSignatures.add(signer.signDecorated(txHash));
    }

    public void sign(byte[] preimage) {
        Preconditions.checkNotNull(preimage, "preimage cannot be null");
        Signature signature = new Signature();
        signature.setSignature(preimage);
        byte[] hash = Util.hash(preimage);
        byte[] signatureHintBytes = Arrays.copyOfRange(hash, hash.length - 4, hash.length);
        SignatureHint signatureHint = new SignatureHint();
        signatureHint.setSignatureHint(signatureHintBytes);
        DecoratedSignature decoratedSignature = new DecoratedSignature();
        decoratedSignature.setHint(signatureHint);
        decoratedSignature.setSignature(signature);
        this.mSignatures.add(decoratedSignature);
    }

    public byte[] hash() {
        return Util.hash(this.signatureBase());
    }

    public String hashHex() {
        return BaseEncoding.base16().lowerCase().encode(this.hash());
    }

    public abstract byte[] signatureBase();

    public Network getNetwork() {
        return this.mNetwork;
    }

    public List<DecoratedSignature> getSignatures() {
        return this.mSignatures;
    }

    public abstract TransactionEnvelope toEnvelopeXdr();

    public String toEnvelopeXdrBase64() {
        try {
            TransactionEnvelope envelope = this.toEnvelopeXdr();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrOutputStream = new XdrDataOutputStream(outputStream);
            TransactionEnvelope.encode(xdrOutputStream, envelope);
            BaseEncoding base64Encoding = BaseEncoding.base64();
            return base64Encoding.encode(outputStream.toByteArray());
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static AbstractTransaction fromEnvelopeXdr(AccountConverter accountConverter, TransactionEnvelope envelope, Network network) {
        switch (envelope.getDiscriminant()) {
            case ENVELOPE_TYPE_TX: {
                return Transaction.fromV1EnvelopeXdr(accountConverter, envelope.getV1(), network);
            }
            case ENVELOPE_TYPE_TX_V0: {
                return Transaction.fromV0EnvelopeXdr(accountConverter, envelope.getV0(), network);
            }
            case ENVELOPE_TYPE_TX_FEE_BUMP: {
                return FeeBumpTransaction.fromFeeBumpTransactionEnvelope(accountConverter, envelope.getFeeBump(), network);
            }
        }
        throw new IllegalArgumentException("transaction type is not supported: " + envelope.getDiscriminant());
    }

    public static AbstractTransaction fromEnvelopeXdr(TransactionEnvelope envelope, Network network) {
        return AbstractTransaction.fromEnvelopeXdr(AccountConverter.disableMuxed(), envelope, network);
    }

    public static AbstractTransaction fromEnvelopeXdr(AccountConverter accountConverter, String envelope, Network network) throws IOException {
        BaseEncoding base64Encoding = BaseEncoding.base64();
        byte[] bytes = base64Encoding.decode(envelope);
        TransactionEnvelope transactionEnvelope = TransactionEnvelope.decode(new XdrDataInputStream(new ByteArrayInputStream(bytes)));
        return AbstractTransaction.fromEnvelopeXdr(accountConverter, transactionEnvelope, network);
    }

    public static AbstractTransaction fromEnvelopeXdr(String envelope, Network network) throws IOException {
        return AbstractTransaction.fromEnvelopeXdr(AccountConverter.disableMuxed(), envelope, network);
    }

    public static byte[] getTransactionSignatureBase(TransactionSignaturePayload.TransactionSignaturePayloadTaggedTransaction taggedTransaction, Network network) {
        try {
            TransactionSignaturePayload payload = new TransactionSignaturePayload();
            Hash hash = new Hash();
            hash.setHash(network.getNetworkId());
            payload.setNetworkId(hash);
            payload.setTaggedTransaction(taggedTransaction);
            ByteArrayOutputStream txOutputStream = new ByteArrayOutputStream();
            XdrDataOutputStream xdrOutputStream = new XdrDataOutputStream(txOutputStream);
            payload.encode(xdrOutputStream);
            return txOutputStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

