/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Liabilities;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class TrustLineEntry
implements XdrElement {
    private AccountID accountID;
    private Asset asset;
    private Int64 balance;
    private Int64 limit;
    private Uint32 flags;
    private TrustLineEntryExt ext;

    public AccountID getAccountID() {
        return this.accountID;
    }

    public void setAccountID(AccountID value) {
        this.accountID = value;
    }

    public Asset getAsset() {
        return this.asset;
    }

    public void setAsset(Asset value) {
        this.asset = value;
    }

    public Int64 getBalance() {
        return this.balance;
    }

    public void setBalance(Int64 value) {
        this.balance = value;
    }

    public Int64 getLimit() {
        return this.limit;
    }

    public void setLimit(Int64 value) {
        this.limit = value;
    }

    public Uint32 getFlags() {
        return this.flags;
    }

    public void setFlags(Uint32 value) {
        this.flags = value;
    }

    public TrustLineEntryExt getExt() {
        return this.ext;
    }

    public void setExt(TrustLineEntryExt value) {
        this.ext = value;
    }

    public static void encode(XdrDataOutputStream stream, TrustLineEntry encodedTrustLineEntry) throws IOException {
        AccountID.encode(stream, encodedTrustLineEntry.accountID);
        Asset.encode(stream, encodedTrustLineEntry.asset);
        Int64.encode(stream, encodedTrustLineEntry.balance);
        Int64.encode(stream, encodedTrustLineEntry.limit);
        Uint32.encode(stream, encodedTrustLineEntry.flags);
        TrustLineEntryExt.encode(stream, encodedTrustLineEntry.ext);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        TrustLineEntry.encode(stream, this);
    }

    public static TrustLineEntry decode(XdrDataInputStream stream) throws IOException {
        TrustLineEntry decodedTrustLineEntry = new TrustLineEntry();
        decodedTrustLineEntry.accountID = AccountID.decode(stream);
        decodedTrustLineEntry.asset = Asset.decode(stream);
        decodedTrustLineEntry.balance = Int64.decode(stream);
        decodedTrustLineEntry.limit = Int64.decode(stream);
        decodedTrustLineEntry.flags = Uint32.decode(stream);
        decodedTrustLineEntry.ext = TrustLineEntryExt.decode(stream);
        return decodedTrustLineEntry;
    }

    public int hashCode() {
        return Objects.hashCode(this.accountID, this.asset, this.balance, this.limit, this.flags, this.ext);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof TrustLineEntry)) {
            return false;
        }
        TrustLineEntry other = (TrustLineEntry)object;
        return Objects.equal(this.accountID, other.accountID) && Objects.equal(this.asset, other.asset) && Objects.equal(this.balance, other.balance) && Objects.equal(this.limit, other.limit) && Objects.equal(this.flags, other.flags) && Objects.equal(this.ext, other.ext);
    }

    public static class TrustLineEntryExt {
        Integer v;
        private TrustLineEntryV1 v1;

        public Integer getDiscriminant() {
            return this.v;
        }

        public void setDiscriminant(Integer value) {
            this.v = value;
        }

        public TrustLineEntryV1 getV1() {
            return this.v1;
        }

        public void setV1(TrustLineEntryV1 value) {
            this.v1 = value;
        }

        public static void encode(XdrDataOutputStream stream, TrustLineEntryExt encodedTrustLineEntryExt) throws IOException {
            stream.writeInt(encodedTrustLineEntryExt.getDiscriminant());
            switch (encodedTrustLineEntryExt.getDiscriminant()) {
                case 0: {
                    break;
                }
                case 1: {
                    TrustLineEntryV1.encode(stream, encodedTrustLineEntryExt.v1);
                }
            }
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            TrustLineEntryExt.encode(stream, this);
        }

        public static TrustLineEntryExt decode(XdrDataInputStream stream) throws IOException {
            TrustLineEntryExt decodedTrustLineEntryExt = new TrustLineEntryExt();
            Integer discriminant = stream.readInt();
            decodedTrustLineEntryExt.setDiscriminant(discriminant);
            switch (decodedTrustLineEntryExt.getDiscriminant()) {
                case 0: {
                    break;
                }
                case 1: {
                    decodedTrustLineEntryExt.v1 = TrustLineEntryV1.decode(stream);
                }
            }
            return decodedTrustLineEntryExt;
        }

        public int hashCode() {
            return Objects.hashCode(this.v1, this.v);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof TrustLineEntryExt)) {
                return false;
            }
            TrustLineEntryExt other = (TrustLineEntryExt)object;
            return Objects.equal(this.v1, other.v1) && Objects.equal(this.v, other.v);
        }

        public static class TrustLineEntryV1 {
            private Liabilities liabilities;
            private TrustLineEntryV1Ext ext;

            public Liabilities getLiabilities() {
                return this.liabilities;
            }

            public void setLiabilities(Liabilities value) {
                this.liabilities = value;
            }

            public TrustLineEntryV1Ext getExt() {
                return this.ext;
            }

            public void setExt(TrustLineEntryV1Ext value) {
                this.ext = value;
            }

            public static void encode(XdrDataOutputStream stream, TrustLineEntryV1 encodedTrustLineEntryV1) throws IOException {
                Liabilities.encode(stream, encodedTrustLineEntryV1.liabilities);
                TrustLineEntryV1Ext.encode(stream, encodedTrustLineEntryV1.ext);
            }

            public void encode(XdrDataOutputStream stream) throws IOException {
                TrustLineEntryV1.encode(stream, this);
            }

            public static TrustLineEntryV1 decode(XdrDataInputStream stream) throws IOException {
                TrustLineEntryV1 decodedTrustLineEntryV1 = new TrustLineEntryV1();
                decodedTrustLineEntryV1.liabilities = Liabilities.decode(stream);
                decodedTrustLineEntryV1.ext = TrustLineEntryV1Ext.decode(stream);
                return decodedTrustLineEntryV1;
            }

            public int hashCode() {
                return Objects.hashCode(this.liabilities, this.ext);
            }

            public boolean equals(Object object) {
                if (object == null || !(object instanceof TrustLineEntryV1)) {
                    return false;
                }
                TrustLineEntryV1 other = (TrustLineEntryV1)object;
                return Objects.equal(this.liabilities, other.liabilities) && Objects.equal(this.ext, other.ext);
            }

            public static class TrustLineEntryV1Ext {
                Integer v;

                public Integer getDiscriminant() {
                    return this.v;
                }

                public void setDiscriminant(Integer value) {
                    this.v = value;
                }

                public static void encode(XdrDataOutputStream stream, TrustLineEntryV1Ext encodedTrustLineEntryV1Ext) throws IOException {
                    stream.writeInt(encodedTrustLineEntryV1Ext.getDiscriminant());
                    switch (encodedTrustLineEntryV1Ext.getDiscriminant()) {
                        default: 
                    }
                }

                public void encode(XdrDataOutputStream stream) throws IOException {
                    TrustLineEntryV1Ext.encode(stream, this);
                }

                public static TrustLineEntryV1Ext decode(XdrDataInputStream stream) throws IOException {
                    TrustLineEntryV1Ext decodedTrustLineEntryV1Ext = new TrustLineEntryV1Ext();
                    Integer discriminant = stream.readInt();
                    decodedTrustLineEntryV1Ext.setDiscriminant(discriminant);
                    switch (decodedTrustLineEntryV1Ext.getDiscriminant()) {
                        default: 
                    }
                    return decodedTrustLineEntryV1Ext;
                }

                public int hashCode() {
                    return Objects.hashCode(this.v);
                }

                public boolean equals(Object object) {
                    if (object == null || !(object instanceof TrustLineEntryV1Ext)) {
                        return false;
                    }
                    TrustLineEntryV1Ext other = (TrustLineEntryV1Ext)object;
                    return Objects.equal(this.v, other.v);
                }
            }
        }
    }
}

