/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import java.util.Arrays;
import org.stellar.sdk.xdr.DecoratedSignature;
import org.stellar.sdk.xdr.TransactionV0;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class TransactionV0Envelope
implements XdrElement {
    private TransactionV0 tx;
    private DecoratedSignature[] signatures;

    public TransactionV0 getTx() {
        return this.tx;
    }

    public void setTx(TransactionV0 value) {
        this.tx = value;
    }

    public DecoratedSignature[] getSignatures() {
        return this.signatures;
    }

    public void setSignatures(DecoratedSignature[] value) {
        this.signatures = value;
    }

    public static void encode(XdrDataOutputStream stream, TransactionV0Envelope encodedTransactionV0Envelope) throws IOException {
        TransactionV0.encode(stream, encodedTransactionV0Envelope.tx);
        int signaturessize = encodedTransactionV0Envelope.getSignatures().length;
        stream.writeInt(signaturessize);
        for (int i = 0; i < signaturessize; ++i) {
            DecoratedSignature.encode(stream, encodedTransactionV0Envelope.signatures[i]);
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        TransactionV0Envelope.encode(stream, this);
    }

    public static TransactionV0Envelope decode(XdrDataInputStream stream) throws IOException {
        TransactionV0Envelope decodedTransactionV0Envelope = new TransactionV0Envelope();
        decodedTransactionV0Envelope.tx = TransactionV0.decode(stream);
        int signaturessize = stream.readInt();
        decodedTransactionV0Envelope.signatures = new DecoratedSignature[signaturessize];
        for (int i = 0; i < signaturessize; ++i) {
            decodedTransactionV0Envelope.signatures[i] = DecoratedSignature.decode(stream);
        }
        return decodedTransactionV0Envelope;
    }

    public int hashCode() {
        return Objects.hashCode(this.tx, Arrays.hashCode(this.signatures));
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof TransactionV0Envelope)) {
            return false;
        }
        TransactionV0Envelope other = (TransactionV0Envelope)object;
        return Objects.equal(this.tx, other.tx) && Arrays.equals(this.signatures, other.signatures);
    }
}

