/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import java.util.Arrays;
import org.stellar.sdk.xdr.Memo;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.SequenceNumber;
import org.stellar.sdk.xdr.TimeBounds;
import org.stellar.sdk.xdr.Uint256;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class TransactionV0
implements XdrElement {
    private Uint256 sourceAccountEd25519;
    private Uint32 fee;
    private SequenceNumber seqNum;
    private TimeBounds timeBounds;
    private Memo memo;
    private Operation[] operations;
    private TransactionV0Ext ext;

    public Uint256 getSourceAccountEd25519() {
        return this.sourceAccountEd25519;
    }

    public void setSourceAccountEd25519(Uint256 value) {
        this.sourceAccountEd25519 = value;
    }

    public Uint32 getFee() {
        return this.fee;
    }

    public void setFee(Uint32 value) {
        this.fee = value;
    }

    public SequenceNumber getSeqNum() {
        return this.seqNum;
    }

    public void setSeqNum(SequenceNumber value) {
        this.seqNum = value;
    }

    public TimeBounds getTimeBounds() {
        return this.timeBounds;
    }

    public void setTimeBounds(TimeBounds value) {
        this.timeBounds = value;
    }

    public Memo getMemo() {
        return this.memo;
    }

    public void setMemo(Memo value) {
        this.memo = value;
    }

    public Operation[] getOperations() {
        return this.operations;
    }

    public void setOperations(Operation[] value) {
        this.operations = value;
    }

    public TransactionV0Ext getExt() {
        return this.ext;
    }

    public void setExt(TransactionV0Ext value) {
        this.ext = value;
    }

    public static void encode(XdrDataOutputStream stream, TransactionV0 encodedTransactionV0) throws IOException {
        Uint256.encode(stream, encodedTransactionV0.sourceAccountEd25519);
        Uint32.encode(stream, encodedTransactionV0.fee);
        SequenceNumber.encode(stream, encodedTransactionV0.seqNum);
        if (encodedTransactionV0.timeBounds != null) {
            stream.writeInt(1);
            TimeBounds.encode(stream, encodedTransactionV0.timeBounds);
        } else {
            stream.writeInt(0);
        }
        Memo.encode(stream, encodedTransactionV0.memo);
        int operationssize = encodedTransactionV0.getOperations().length;
        stream.writeInt(operationssize);
        for (int i = 0; i < operationssize; ++i) {
            Operation.encode(stream, encodedTransactionV0.operations[i]);
        }
        TransactionV0Ext.encode(stream, encodedTransactionV0.ext);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        TransactionV0.encode(stream, this);
    }

    public static TransactionV0 decode(XdrDataInputStream stream) throws IOException {
        TransactionV0 decodedTransactionV0 = new TransactionV0();
        decodedTransactionV0.sourceAccountEd25519 = Uint256.decode(stream);
        decodedTransactionV0.fee = Uint32.decode(stream);
        decodedTransactionV0.seqNum = SequenceNumber.decode(stream);
        int timeBoundsPresent = stream.readInt();
        if (timeBoundsPresent != 0) {
            decodedTransactionV0.timeBounds = TimeBounds.decode(stream);
        }
        decodedTransactionV0.memo = Memo.decode(stream);
        int operationssize = stream.readInt();
        decodedTransactionV0.operations = new Operation[operationssize];
        for (int i = 0; i < operationssize; ++i) {
            decodedTransactionV0.operations[i] = Operation.decode(stream);
        }
        decodedTransactionV0.ext = TransactionV0Ext.decode(stream);
        return decodedTransactionV0;
    }

    public int hashCode() {
        return Objects.hashCode(this.sourceAccountEd25519, this.fee, this.seqNum, this.timeBounds, this.memo, Arrays.hashCode(this.operations), this.ext);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof TransactionV0)) {
            return false;
        }
        TransactionV0 other = (TransactionV0)object;
        return Objects.equal(this.sourceAccountEd25519, other.sourceAccountEd25519) && Objects.equal(this.fee, other.fee) && Objects.equal(this.seqNum, other.seqNum) && Objects.equal(this.timeBounds, other.timeBounds) && Objects.equal(this.memo, other.memo) && Arrays.equals(this.operations, other.operations) && Objects.equal(this.ext, other.ext);
    }

    public static class TransactionV0Ext {
        Integer v;

        public Integer getDiscriminant() {
            return this.v;
        }

        public void setDiscriminant(Integer value) {
            this.v = value;
        }

        public static void encode(XdrDataOutputStream stream, TransactionV0Ext encodedTransactionV0Ext) throws IOException {
            stream.writeInt(encodedTransactionV0Ext.getDiscriminant());
            switch (encodedTransactionV0Ext.getDiscriminant()) {
                default: 
            }
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            TransactionV0Ext.encode(stream, this);
        }

        public static TransactionV0Ext decode(XdrDataInputStream stream) throws IOException {
            TransactionV0Ext decodedTransactionV0Ext = new TransactionV0Ext();
            Integer discriminant = stream.readInt();
            decodedTransactionV0Ext.setDiscriminant(discriminant);
            switch (decodedTransactionV0Ext.getDiscriminant()) {
                default: 
            }
            return decodedTransactionV0Ext;
        }

        public int hashCode() {
            return Objects.hashCode(this.v);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof TransactionV0Ext)) {
                return false;
            }
            TransactionV0Ext other = (TransactionV0Ext)object;
            return Objects.equal(this.v, other.v);
        }
    }
}

