/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.EnvelopeType;
import org.stellar.sdk.xdr.FeeBumpTransaction;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.Transaction;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class TransactionSignaturePayload
implements XdrElement {
    private Hash networkId;
    private TransactionSignaturePayloadTaggedTransaction taggedTransaction;

    public Hash getNetworkId() {
        return this.networkId;
    }

    public void setNetworkId(Hash value) {
        this.networkId = value;
    }

    public TransactionSignaturePayloadTaggedTransaction getTaggedTransaction() {
        return this.taggedTransaction;
    }

    public void setTaggedTransaction(TransactionSignaturePayloadTaggedTransaction value) {
        this.taggedTransaction = value;
    }

    public static void encode(XdrDataOutputStream stream, TransactionSignaturePayload encodedTransactionSignaturePayload) throws IOException {
        Hash.encode(stream, encodedTransactionSignaturePayload.networkId);
        TransactionSignaturePayloadTaggedTransaction.encode(stream, encodedTransactionSignaturePayload.taggedTransaction);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        TransactionSignaturePayload.encode(stream, this);
    }

    public static TransactionSignaturePayload decode(XdrDataInputStream stream) throws IOException {
        TransactionSignaturePayload decodedTransactionSignaturePayload = new TransactionSignaturePayload();
        decodedTransactionSignaturePayload.networkId = Hash.decode(stream);
        decodedTransactionSignaturePayload.taggedTransaction = TransactionSignaturePayloadTaggedTransaction.decode(stream);
        return decodedTransactionSignaturePayload;
    }

    public int hashCode() {
        return Objects.hashCode(this.networkId, this.taggedTransaction);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof TransactionSignaturePayload)) {
            return false;
        }
        TransactionSignaturePayload other = (TransactionSignaturePayload)object;
        return Objects.equal(this.networkId, other.networkId) && Objects.equal(this.taggedTransaction, other.taggedTransaction);
    }

    public static class TransactionSignaturePayloadTaggedTransaction {
        EnvelopeType type;
        private Transaction tx;
        private FeeBumpTransaction feeBump;

        public EnvelopeType getDiscriminant() {
            return this.type;
        }

        public void setDiscriminant(EnvelopeType value) {
            this.type = value;
        }

        public Transaction getTx() {
            return this.tx;
        }

        public void setTx(Transaction value) {
            this.tx = value;
        }

        public FeeBumpTransaction getFeeBump() {
            return this.feeBump;
        }

        public void setFeeBump(FeeBumpTransaction value) {
            this.feeBump = value;
        }

        public static void encode(XdrDataOutputStream stream, TransactionSignaturePayloadTaggedTransaction encodedTransactionSignaturePayloadTaggedTransaction) throws IOException {
            stream.writeInt(encodedTransactionSignaturePayloadTaggedTransaction.getDiscriminant().getValue());
            switch (encodedTransactionSignaturePayloadTaggedTransaction.getDiscriminant()) {
                case ENVELOPE_TYPE_TX: {
                    Transaction.encode(stream, encodedTransactionSignaturePayloadTaggedTransaction.tx);
                    break;
                }
                case ENVELOPE_TYPE_TX_FEE_BUMP: {
                    FeeBumpTransaction.encode(stream, encodedTransactionSignaturePayloadTaggedTransaction.feeBump);
                }
            }
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            TransactionSignaturePayloadTaggedTransaction.encode(stream, this);
        }

        public static TransactionSignaturePayloadTaggedTransaction decode(XdrDataInputStream stream) throws IOException {
            TransactionSignaturePayloadTaggedTransaction decodedTransactionSignaturePayloadTaggedTransaction = new TransactionSignaturePayloadTaggedTransaction();
            EnvelopeType discriminant = EnvelopeType.decode(stream);
            decodedTransactionSignaturePayloadTaggedTransaction.setDiscriminant(discriminant);
            switch (decodedTransactionSignaturePayloadTaggedTransaction.getDiscriminant()) {
                case ENVELOPE_TYPE_TX: {
                    decodedTransactionSignaturePayloadTaggedTransaction.tx = Transaction.decode(stream);
                    break;
                }
                case ENVELOPE_TYPE_TX_FEE_BUMP: {
                    decodedTransactionSignaturePayloadTaggedTransaction.feeBump = FeeBumpTransaction.decode(stream);
                }
            }
            return decodedTransactionSignaturePayloadTaggedTransaction;
        }

        public int hashCode() {
            return Objects.hashCode(this.tx, this.feeBump, this.type);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof TransactionSignaturePayloadTaggedTransaction)) {
                return false;
            }
            TransactionSignaturePayloadTaggedTransaction other = (TransactionSignaturePayloadTaggedTransaction)object;
            return Objects.equal(this.tx, other.tx) && Objects.equal(this.feeBump, other.feeBump) && Objects.equal(this.type, other.type);
        }
    }
}

