/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import java.util.Arrays;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.TransactionEnvelope;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class TransactionSet
implements XdrElement {
    private Hash previousLedgerHash;
    private TransactionEnvelope[] txs;

    public Hash getPreviousLedgerHash() {
        return this.previousLedgerHash;
    }

    public void setPreviousLedgerHash(Hash value) {
        this.previousLedgerHash = value;
    }

    public TransactionEnvelope[] getTxs() {
        return this.txs;
    }

    public void setTxs(TransactionEnvelope[] value) {
        this.txs = value;
    }

    public static void encode(XdrDataOutputStream stream, TransactionSet encodedTransactionSet) throws IOException {
        Hash.encode(stream, encodedTransactionSet.previousLedgerHash);
        int txssize = encodedTransactionSet.getTxs().length;
        stream.writeInt(txssize);
        for (int i = 0; i < txssize; ++i) {
            TransactionEnvelope.encode(stream, encodedTransactionSet.txs[i]);
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        TransactionSet.encode(stream, this);
    }

    public static TransactionSet decode(XdrDataInputStream stream) throws IOException {
        TransactionSet decodedTransactionSet = new TransactionSet();
        decodedTransactionSet.previousLedgerHash = Hash.decode(stream);
        int txssize = stream.readInt();
        decodedTransactionSet.txs = new TransactionEnvelope[txssize];
        for (int i = 0; i < txssize; ++i) {
            decodedTransactionSet.txs[i] = TransactionEnvelope.decode(stream);
        }
        return decodedTransactionSet;
    }

    public int hashCode() {
        return Objects.hashCode(this.previousLedgerHash, Arrays.hashCode(this.txs));
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof TransactionSet)) {
            return false;
        }
        TransactionSet other = (TransactionSet)object;
        return Objects.equal(this.previousLedgerHash, other.previousLedgerHash) && Arrays.equals(this.txs, other.txs);
    }
}

