/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import java.util.Arrays;
import org.stellar.sdk.xdr.OperationMeta;
import org.stellar.sdk.xdr.TransactionMetaV1;
import org.stellar.sdk.xdr.TransactionMetaV2;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class TransactionMeta
implements XdrElement {
    Integer v;
    private OperationMeta[] operations;
    private TransactionMetaV1 v1;
    private TransactionMetaV2 v2;

    public Integer getDiscriminant() {
        return this.v;
    }

    public void setDiscriminant(Integer value) {
        this.v = value;
    }

    public OperationMeta[] getOperations() {
        return this.operations;
    }

    public void setOperations(OperationMeta[] value) {
        this.operations = value;
    }

    public TransactionMetaV1 getV1() {
        return this.v1;
    }

    public void setV1(TransactionMetaV1 value) {
        this.v1 = value;
    }

    public TransactionMetaV2 getV2() {
        return this.v2;
    }

    public void setV2(TransactionMetaV2 value) {
        this.v2 = value;
    }

    public static void encode(XdrDataOutputStream stream, TransactionMeta encodedTransactionMeta) throws IOException {
        stream.writeInt(encodedTransactionMeta.getDiscriminant());
        switch (encodedTransactionMeta.getDiscriminant()) {
            case 0: {
                int operationssize = encodedTransactionMeta.getOperations().length;
                stream.writeInt(operationssize);
                for (int i = 0; i < operationssize; ++i) {
                    OperationMeta.encode(stream, encodedTransactionMeta.operations[i]);
                }
                break;
            }
            case 1: {
                TransactionMetaV1.encode(stream, encodedTransactionMeta.v1);
                break;
            }
            case 2: {
                TransactionMetaV2.encode(stream, encodedTransactionMeta.v2);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        TransactionMeta.encode(stream, this);
    }

    public static TransactionMeta decode(XdrDataInputStream stream) throws IOException {
        TransactionMeta decodedTransactionMeta = new TransactionMeta();
        Integer discriminant = stream.readInt();
        decodedTransactionMeta.setDiscriminant(discriminant);
        switch (decodedTransactionMeta.getDiscriminant()) {
            case 0: {
                int operationssize = stream.readInt();
                decodedTransactionMeta.operations = new OperationMeta[operationssize];
                for (int i = 0; i < operationssize; ++i) {
                    decodedTransactionMeta.operations[i] = OperationMeta.decode(stream);
                }
                break;
            }
            case 1: {
                decodedTransactionMeta.v1 = TransactionMetaV1.decode(stream);
                break;
            }
            case 2: {
                decodedTransactionMeta.v2 = TransactionMetaV2.decode(stream);
            }
        }
        return decodedTransactionMeta;
    }

    public int hashCode() {
        return Objects.hashCode(Arrays.hashCode(this.operations), this.v1, this.v2, this.v);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof TransactionMeta)) {
            return false;
        }
        TransactionMeta other = (TransactionMeta)object;
        return Arrays.equals(this.operations, other.operations) && Objects.equal(this.v1, other.v1) && Objects.equal(this.v2, other.v2) && Objects.equal(this.v, other.v);
    }
}

