/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.TransactionSet;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class TransactionHistoryEntry
implements XdrElement {
    private Uint32 ledgerSeq;
    private TransactionSet txSet;
    private TransactionHistoryEntryExt ext;

    public Uint32 getLedgerSeq() {
        return this.ledgerSeq;
    }

    public void setLedgerSeq(Uint32 value) {
        this.ledgerSeq = value;
    }

    public TransactionSet getTxSet() {
        return this.txSet;
    }

    public void setTxSet(TransactionSet value) {
        this.txSet = value;
    }

    public TransactionHistoryEntryExt getExt() {
        return this.ext;
    }

    public void setExt(TransactionHistoryEntryExt value) {
        this.ext = value;
    }

    public static void encode(XdrDataOutputStream stream, TransactionHistoryEntry encodedTransactionHistoryEntry) throws IOException {
        Uint32.encode(stream, encodedTransactionHistoryEntry.ledgerSeq);
        TransactionSet.encode(stream, encodedTransactionHistoryEntry.txSet);
        TransactionHistoryEntryExt.encode(stream, encodedTransactionHistoryEntry.ext);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        TransactionHistoryEntry.encode(stream, this);
    }

    public static TransactionHistoryEntry decode(XdrDataInputStream stream) throws IOException {
        TransactionHistoryEntry decodedTransactionHistoryEntry = new TransactionHistoryEntry();
        decodedTransactionHistoryEntry.ledgerSeq = Uint32.decode(stream);
        decodedTransactionHistoryEntry.txSet = TransactionSet.decode(stream);
        decodedTransactionHistoryEntry.ext = TransactionHistoryEntryExt.decode(stream);
        return decodedTransactionHistoryEntry;
    }

    public int hashCode() {
        return Objects.hashCode(this.ledgerSeq, this.txSet, this.ext);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof TransactionHistoryEntry)) {
            return false;
        }
        TransactionHistoryEntry other = (TransactionHistoryEntry)object;
        return Objects.equal(this.ledgerSeq, other.ledgerSeq) && Objects.equal(this.txSet, other.txSet) && Objects.equal(this.ext, other.ext);
    }

    public static class TransactionHistoryEntryExt {
        Integer v;

        public Integer getDiscriminant() {
            return this.v;
        }

        public void setDiscriminant(Integer value) {
            this.v = value;
        }

        public static void encode(XdrDataOutputStream stream, TransactionHistoryEntryExt encodedTransactionHistoryEntryExt) throws IOException {
            stream.writeInt(encodedTransactionHistoryEntryExt.getDiscriminant());
            switch (encodedTransactionHistoryEntryExt.getDiscriminant()) {
                default: 
            }
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            TransactionHistoryEntryExt.encode(stream, this);
        }

        public static TransactionHistoryEntryExt decode(XdrDataInputStream stream) throws IOException {
            TransactionHistoryEntryExt decodedTransactionHistoryEntryExt = new TransactionHistoryEntryExt();
            Integer discriminant = stream.readInt();
            decodedTransactionHistoryEntryExt.setDiscriminant(discriminant);
            switch (decodedTransactionHistoryEntryExt.getDiscriminant()) {
                default: 
            }
            return decodedTransactionHistoryEntryExt;
        }

        public int hashCode() {
            return Objects.hashCode(this.v);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof TransactionHistoryEntryExt)) {
                return false;
            }
            TransactionHistoryEntryExt other = (TransactionHistoryEntryExt)object;
            return Objects.equal(this.v, other.v);
        }
    }
}

