/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.TimePoint;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class TimeBounds
implements XdrElement {
    private TimePoint minTime;
    private TimePoint maxTime;

    public TimePoint getMinTime() {
        return this.minTime;
    }

    public void setMinTime(TimePoint value) {
        this.minTime = value;
    }

    public TimePoint getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(TimePoint value) {
        this.maxTime = value;
    }

    public static void encode(XdrDataOutputStream stream, TimeBounds encodedTimeBounds) throws IOException {
        TimePoint.encode(stream, encodedTimeBounds.minTime);
        TimePoint.encode(stream, encodedTimeBounds.maxTime);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        TimeBounds.encode(stream, this);
    }

    public static TimeBounds decode(XdrDataInputStream stream) throws IOException {
        TimeBounds decodedTimeBounds = new TimeBounds();
        decodedTimeBounds.minTime = TimePoint.decode(stream);
        decodedTimeBounds.maxTime = TimePoint.decode(stream);
        return decodedTimeBounds;
    }

    public int hashCode() {
        return Objects.hashCode(this.minTime, this.maxTime);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof TimeBounds)) {
            return false;
        }
        TimeBounds other = (TimeBounds)object;
        return Objects.equal(this.minTime, other.minTime) && Objects.equal(this.maxTime, other.maxTime);
    }
}

