/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.EncryptedBody;
import org.stellar.sdk.xdr.NodeID;
import org.stellar.sdk.xdr.SurveyMessageCommandType;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class SurveyResponseMessage
implements XdrElement {
    private NodeID surveyorPeerID;
    private NodeID surveyedPeerID;
    private Uint32 ledgerNum;
    private SurveyMessageCommandType commandType;
    private EncryptedBody encryptedBody;

    public NodeID getSurveyorPeerID() {
        return this.surveyorPeerID;
    }

    public void setSurveyorPeerID(NodeID value) {
        this.surveyorPeerID = value;
    }

    public NodeID getSurveyedPeerID() {
        return this.surveyedPeerID;
    }

    public void setSurveyedPeerID(NodeID value) {
        this.surveyedPeerID = value;
    }

    public Uint32 getLedgerNum() {
        return this.ledgerNum;
    }

    public void setLedgerNum(Uint32 value) {
        this.ledgerNum = value;
    }

    public SurveyMessageCommandType getCommandType() {
        return this.commandType;
    }

    public void setCommandType(SurveyMessageCommandType value) {
        this.commandType = value;
    }

    public EncryptedBody getEncryptedBody() {
        return this.encryptedBody;
    }

    public void setEncryptedBody(EncryptedBody value) {
        this.encryptedBody = value;
    }

    public static void encode(XdrDataOutputStream stream, SurveyResponseMessage encodedSurveyResponseMessage) throws IOException {
        NodeID.encode(stream, encodedSurveyResponseMessage.surveyorPeerID);
        NodeID.encode(stream, encodedSurveyResponseMessage.surveyedPeerID);
        Uint32.encode(stream, encodedSurveyResponseMessage.ledgerNum);
        SurveyMessageCommandType.encode(stream, encodedSurveyResponseMessage.commandType);
        EncryptedBody.encode(stream, encodedSurveyResponseMessage.encryptedBody);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SurveyResponseMessage.encode(stream, this);
    }

    public static SurveyResponseMessage decode(XdrDataInputStream stream) throws IOException {
        SurveyResponseMessage decodedSurveyResponseMessage = new SurveyResponseMessage();
        decodedSurveyResponseMessage.surveyorPeerID = NodeID.decode(stream);
        decodedSurveyResponseMessage.surveyedPeerID = NodeID.decode(stream);
        decodedSurveyResponseMessage.ledgerNum = Uint32.decode(stream);
        decodedSurveyResponseMessage.commandType = SurveyMessageCommandType.decode(stream);
        decodedSurveyResponseMessage.encryptedBody = EncryptedBody.decode(stream);
        return decodedSurveyResponseMessage;
    }

    public int hashCode() {
        return Objects.hashCode(this.surveyorPeerID, this.surveyedPeerID, this.ledgerNum, this.commandType, this.encryptedBody);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SurveyResponseMessage)) {
            return false;
        }
        SurveyResponseMessage other = (SurveyResponseMessage)object;
        return Objects.equal(this.surveyorPeerID, other.surveyorPeerID) && Objects.equal(this.surveyedPeerID, other.surveyedPeerID) && Objects.equal(this.ledgerNum, other.ledgerNum) && Objects.equal(this.commandType, other.commandType) && Objects.equal(this.encryptedBody, other.encryptedBody);
    }
}

