/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.Curve25519Public;
import org.stellar.sdk.xdr.NodeID;
import org.stellar.sdk.xdr.SurveyMessageCommandType;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class SurveyRequestMessage
implements XdrElement {
    private NodeID surveyorPeerID;
    private NodeID surveyedPeerID;
    private Uint32 ledgerNum;
    private Curve25519Public encryptionKey;
    private SurveyMessageCommandType commandType;

    public NodeID getSurveyorPeerID() {
        return this.surveyorPeerID;
    }

    public void setSurveyorPeerID(NodeID value) {
        this.surveyorPeerID = value;
    }

    public NodeID getSurveyedPeerID() {
        return this.surveyedPeerID;
    }

    public void setSurveyedPeerID(NodeID value) {
        this.surveyedPeerID = value;
    }

    public Uint32 getLedgerNum() {
        return this.ledgerNum;
    }

    public void setLedgerNum(Uint32 value) {
        this.ledgerNum = value;
    }

    public Curve25519Public getEncryptionKey() {
        return this.encryptionKey;
    }

    public void setEncryptionKey(Curve25519Public value) {
        this.encryptionKey = value;
    }

    public SurveyMessageCommandType getCommandType() {
        return this.commandType;
    }

    public void setCommandType(SurveyMessageCommandType value) {
        this.commandType = value;
    }

    public static void encode(XdrDataOutputStream stream, SurveyRequestMessage encodedSurveyRequestMessage) throws IOException {
        NodeID.encode(stream, encodedSurveyRequestMessage.surveyorPeerID);
        NodeID.encode(stream, encodedSurveyRequestMessage.surveyedPeerID);
        Uint32.encode(stream, encodedSurveyRequestMessage.ledgerNum);
        Curve25519Public.encode(stream, encodedSurveyRequestMessage.encryptionKey);
        SurveyMessageCommandType.encode(stream, encodedSurveyRequestMessage.commandType);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SurveyRequestMessage.encode(stream, this);
    }

    public static SurveyRequestMessage decode(XdrDataInputStream stream) throws IOException {
        SurveyRequestMessage decodedSurveyRequestMessage = new SurveyRequestMessage();
        decodedSurveyRequestMessage.surveyorPeerID = NodeID.decode(stream);
        decodedSurveyRequestMessage.surveyedPeerID = NodeID.decode(stream);
        decodedSurveyRequestMessage.ledgerNum = Uint32.decode(stream);
        decodedSurveyRequestMessage.encryptionKey = Curve25519Public.decode(stream);
        decodedSurveyRequestMessage.commandType = SurveyMessageCommandType.decode(stream);
        return decodedSurveyRequestMessage;
    }

    public int hashCode() {
        return Objects.hashCode(this.surveyorPeerID, this.surveyedPeerID, this.ledgerNum, this.encryptionKey, this.commandType);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SurveyRequestMessage)) {
            return false;
        }
        SurveyRequestMessage other = (SurveyRequestMessage)object;
        return Objects.equal(this.surveyorPeerID, other.surveyorPeerID) && Objects.equal(this.surveyedPeerID, other.surveyedPeerID) && Objects.equal(this.ledgerNum, other.ledgerNum) && Objects.equal(this.encryptionKey, other.encryptionKey) && Objects.equal(this.commandType, other.commandType);
    }
}

