/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum SignerKeyType implements XdrElement
{
    SIGNER_KEY_TYPE_ED25519(0),
    SIGNER_KEY_TYPE_PRE_AUTH_TX(1),
    SIGNER_KEY_TYPE_HASH_X(2);

    private int mValue;

    private SignerKeyType(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static SignerKeyType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return SIGNER_KEY_TYPE_ED25519;
            }
            case 1: {
                return SIGNER_KEY_TYPE_PRE_AUTH_TX;
            }
            case 2: {
                return SIGNER_KEY_TYPE_HASH_X;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, SignerKeyType value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SignerKeyType.encode(stream, this);
    }
}

