/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.SignerKey;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class Signer
implements XdrElement {
    private SignerKey key;
    private Uint32 weight;

    public SignerKey getKey() {
        return this.key;
    }

    public void setKey(SignerKey value) {
        this.key = value;
    }

    public Uint32 getWeight() {
        return this.weight;
    }

    public void setWeight(Uint32 value) {
        this.weight = value;
    }

    public static void encode(XdrDataOutputStream stream, Signer encodedSigner) throws IOException {
        SignerKey.encode(stream, encodedSigner.key);
        Uint32.encode(stream, encodedSigner.weight);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        Signer.encode(stream, this);
    }

    public static Signer decode(XdrDataInputStream stream) throws IOException {
        Signer decodedSigner = new Signer();
        decodedSigner.key = SignerKey.decode(stream);
        decodedSigner.weight = Uint32.decode(stream);
        return decodedSigner;
    }

    public int hashCode() {
        return Objects.hashCode(this.key, this.weight);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Signer)) {
            return false;
        }
        Signer other = (Signer)object;
        return Objects.equal(this.key, other.key) && Objects.equal(this.weight, other.weight);
    }
}

