/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.NodeID;
import org.stellar.sdk.xdr.SCPBallot;
import org.stellar.sdk.xdr.SCPNomination;
import org.stellar.sdk.xdr.SCPStatementType;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class SCPStatement
implements XdrElement {
    private NodeID nodeID;
    private Uint64 slotIndex;
    private SCPStatementPledges pledges;

    public NodeID getNodeID() {
        return this.nodeID;
    }

    public void setNodeID(NodeID value) {
        this.nodeID = value;
    }

    public Uint64 getSlotIndex() {
        return this.slotIndex;
    }

    public void setSlotIndex(Uint64 value) {
        this.slotIndex = value;
    }

    public SCPStatementPledges getPledges() {
        return this.pledges;
    }

    public void setPledges(SCPStatementPledges value) {
        this.pledges = value;
    }

    public static void encode(XdrDataOutputStream stream, SCPStatement encodedSCPStatement) throws IOException {
        NodeID.encode(stream, encodedSCPStatement.nodeID);
        Uint64.encode(stream, encodedSCPStatement.slotIndex);
        SCPStatementPledges.encode(stream, encodedSCPStatement.pledges);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        SCPStatement.encode(stream, this);
    }

    public static SCPStatement decode(XdrDataInputStream stream) throws IOException {
        SCPStatement decodedSCPStatement = new SCPStatement();
        decodedSCPStatement.nodeID = NodeID.decode(stream);
        decodedSCPStatement.slotIndex = Uint64.decode(stream);
        decodedSCPStatement.pledges = SCPStatementPledges.decode(stream);
        return decodedSCPStatement;
    }

    public int hashCode() {
        return Objects.hashCode(this.nodeID, this.slotIndex, this.pledges);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SCPStatement)) {
            return false;
        }
        SCPStatement other = (SCPStatement)object;
        return Objects.equal(this.nodeID, other.nodeID) && Objects.equal(this.slotIndex, other.slotIndex) && Objects.equal(this.pledges, other.pledges);
    }

    public static class SCPStatementPledges {
        SCPStatementType type;
        private SCPStatementPrepare prepare;
        private SCPStatementConfirm confirm;
        private SCPStatementExternalize externalize;
        private SCPNomination nominate;

        public SCPStatementType getDiscriminant() {
            return this.type;
        }

        public void setDiscriminant(SCPStatementType value) {
            this.type = value;
        }

        public SCPStatementPrepare getPrepare() {
            return this.prepare;
        }

        public void setPrepare(SCPStatementPrepare value) {
            this.prepare = value;
        }

        public SCPStatementConfirm getConfirm() {
            return this.confirm;
        }

        public void setConfirm(SCPStatementConfirm value) {
            this.confirm = value;
        }

        public SCPStatementExternalize getExternalize() {
            return this.externalize;
        }

        public void setExternalize(SCPStatementExternalize value) {
            this.externalize = value;
        }

        public SCPNomination getNominate() {
            return this.nominate;
        }

        public void setNominate(SCPNomination value) {
            this.nominate = value;
        }

        public static void encode(XdrDataOutputStream stream, SCPStatementPledges encodedSCPStatementPledges) throws IOException {
            stream.writeInt(encodedSCPStatementPledges.getDiscriminant().getValue());
            switch (encodedSCPStatementPledges.getDiscriminant()) {
                case SCP_ST_PREPARE: {
                    SCPStatementPrepare.encode(stream, encodedSCPStatementPledges.prepare);
                    break;
                }
                case SCP_ST_CONFIRM: {
                    SCPStatementConfirm.encode(stream, encodedSCPStatementPledges.confirm);
                    break;
                }
                case SCP_ST_EXTERNALIZE: {
                    SCPStatementExternalize.encode(stream, encodedSCPStatementPledges.externalize);
                    break;
                }
                case SCP_ST_NOMINATE: {
                    SCPNomination.encode(stream, encodedSCPStatementPledges.nominate);
                }
            }
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            SCPStatementPledges.encode(stream, this);
        }

        public static SCPStatementPledges decode(XdrDataInputStream stream) throws IOException {
            SCPStatementPledges decodedSCPStatementPledges = new SCPStatementPledges();
            SCPStatementType discriminant = SCPStatementType.decode(stream);
            decodedSCPStatementPledges.setDiscriminant(discriminant);
            switch (decodedSCPStatementPledges.getDiscriminant()) {
                case SCP_ST_PREPARE: {
                    decodedSCPStatementPledges.prepare = SCPStatementPrepare.decode(stream);
                    break;
                }
                case SCP_ST_CONFIRM: {
                    decodedSCPStatementPledges.confirm = SCPStatementConfirm.decode(stream);
                    break;
                }
                case SCP_ST_EXTERNALIZE: {
                    decodedSCPStatementPledges.externalize = SCPStatementExternalize.decode(stream);
                    break;
                }
                case SCP_ST_NOMINATE: {
                    decodedSCPStatementPledges.nominate = SCPNomination.decode(stream);
                }
            }
            return decodedSCPStatementPledges;
        }

        public int hashCode() {
            return Objects.hashCode(this.prepare, this.confirm, this.externalize, this.nominate, this.type);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof SCPStatementPledges)) {
                return false;
            }
            SCPStatementPledges other = (SCPStatementPledges)object;
            return Objects.equal(this.prepare, other.prepare) && Objects.equal(this.confirm, other.confirm) && Objects.equal(this.externalize, other.externalize) && Objects.equal(this.nominate, other.nominate) && Objects.equal(this.type, other.type);
        }

        public static class SCPStatementExternalize {
            private SCPBallot commit;
            private Uint32 nH;
            private Hash commitQuorumSetHash;

            public SCPBallot getCommit() {
                return this.commit;
            }

            public void setCommit(SCPBallot value) {
                this.commit = value;
            }

            public Uint32 getNH() {
                return this.nH;
            }

            public void setNH(Uint32 value) {
                this.nH = value;
            }

            public Hash getCommitQuorumSetHash() {
                return this.commitQuorumSetHash;
            }

            public void setCommitQuorumSetHash(Hash value) {
                this.commitQuorumSetHash = value;
            }

            public static void encode(XdrDataOutputStream stream, SCPStatementExternalize encodedSCPStatementExternalize) throws IOException {
                SCPBallot.encode(stream, encodedSCPStatementExternalize.commit);
                Uint32.encode(stream, encodedSCPStatementExternalize.nH);
                Hash.encode(stream, encodedSCPStatementExternalize.commitQuorumSetHash);
            }

            public void encode(XdrDataOutputStream stream) throws IOException {
                SCPStatementExternalize.encode(stream, this);
            }

            public static SCPStatementExternalize decode(XdrDataInputStream stream) throws IOException {
                SCPStatementExternalize decodedSCPStatementExternalize = new SCPStatementExternalize();
                decodedSCPStatementExternalize.commit = SCPBallot.decode(stream);
                decodedSCPStatementExternalize.nH = Uint32.decode(stream);
                decodedSCPStatementExternalize.commitQuorumSetHash = Hash.decode(stream);
                return decodedSCPStatementExternalize;
            }

            public int hashCode() {
                return Objects.hashCode(this.commit, this.nH, this.commitQuorumSetHash);
            }

            public boolean equals(Object object) {
                if (object == null || !(object instanceof SCPStatementExternalize)) {
                    return false;
                }
                SCPStatementExternalize other = (SCPStatementExternalize)object;
                return Objects.equal(this.commit, other.commit) && Objects.equal(this.nH, other.nH) && Objects.equal(this.commitQuorumSetHash, other.commitQuorumSetHash);
            }
        }

        public static class SCPStatementConfirm {
            private SCPBallot ballot;
            private Uint32 nPrepared;
            private Uint32 nCommit;
            private Uint32 nH;
            private Hash quorumSetHash;

            public SCPBallot getBallot() {
                return this.ballot;
            }

            public void setBallot(SCPBallot value) {
                this.ballot = value;
            }

            public Uint32 getNPrepared() {
                return this.nPrepared;
            }

            public void setNPrepared(Uint32 value) {
                this.nPrepared = value;
            }

            public Uint32 getNCommit() {
                return this.nCommit;
            }

            public void setNCommit(Uint32 value) {
                this.nCommit = value;
            }

            public Uint32 getNH() {
                return this.nH;
            }

            public void setNH(Uint32 value) {
                this.nH = value;
            }

            public Hash getQuorumSetHash() {
                return this.quorumSetHash;
            }

            public void setQuorumSetHash(Hash value) {
                this.quorumSetHash = value;
            }

            public static void encode(XdrDataOutputStream stream, SCPStatementConfirm encodedSCPStatementConfirm) throws IOException {
                SCPBallot.encode(stream, encodedSCPStatementConfirm.ballot);
                Uint32.encode(stream, encodedSCPStatementConfirm.nPrepared);
                Uint32.encode(stream, encodedSCPStatementConfirm.nCommit);
                Uint32.encode(stream, encodedSCPStatementConfirm.nH);
                Hash.encode(stream, encodedSCPStatementConfirm.quorumSetHash);
            }

            public void encode(XdrDataOutputStream stream) throws IOException {
                SCPStatementConfirm.encode(stream, this);
            }

            public static SCPStatementConfirm decode(XdrDataInputStream stream) throws IOException {
                SCPStatementConfirm decodedSCPStatementConfirm = new SCPStatementConfirm();
                decodedSCPStatementConfirm.ballot = SCPBallot.decode(stream);
                decodedSCPStatementConfirm.nPrepared = Uint32.decode(stream);
                decodedSCPStatementConfirm.nCommit = Uint32.decode(stream);
                decodedSCPStatementConfirm.nH = Uint32.decode(stream);
                decodedSCPStatementConfirm.quorumSetHash = Hash.decode(stream);
                return decodedSCPStatementConfirm;
            }

            public int hashCode() {
                return Objects.hashCode(this.ballot, this.nPrepared, this.nCommit, this.nH, this.quorumSetHash);
            }

            public boolean equals(Object object) {
                if (object == null || !(object instanceof SCPStatementConfirm)) {
                    return false;
                }
                SCPStatementConfirm other = (SCPStatementConfirm)object;
                return Objects.equal(this.ballot, other.ballot) && Objects.equal(this.nPrepared, other.nPrepared) && Objects.equal(this.nCommit, other.nCommit) && Objects.equal(this.nH, other.nH) && Objects.equal(this.quorumSetHash, other.quorumSetHash);
            }
        }

        public static class SCPStatementPrepare {
            private Hash quorumSetHash;
            private SCPBallot ballot;
            private SCPBallot prepared;
            private SCPBallot preparedPrime;
            private Uint32 nC;
            private Uint32 nH;

            public Hash getQuorumSetHash() {
                return this.quorumSetHash;
            }

            public void setQuorumSetHash(Hash value) {
                this.quorumSetHash = value;
            }

            public SCPBallot getBallot() {
                return this.ballot;
            }

            public void setBallot(SCPBallot value) {
                this.ballot = value;
            }

            public SCPBallot getPrepared() {
                return this.prepared;
            }

            public void setPrepared(SCPBallot value) {
                this.prepared = value;
            }

            public SCPBallot getPreparedPrime() {
                return this.preparedPrime;
            }

            public void setPreparedPrime(SCPBallot value) {
                this.preparedPrime = value;
            }

            public Uint32 getNC() {
                return this.nC;
            }

            public void setNC(Uint32 value) {
                this.nC = value;
            }

            public Uint32 getNH() {
                return this.nH;
            }

            public void setNH(Uint32 value) {
                this.nH = value;
            }

            public static void encode(XdrDataOutputStream stream, SCPStatementPrepare encodedSCPStatementPrepare) throws IOException {
                Hash.encode(stream, encodedSCPStatementPrepare.quorumSetHash);
                SCPBallot.encode(stream, encodedSCPStatementPrepare.ballot);
                if (encodedSCPStatementPrepare.prepared != null) {
                    stream.writeInt(1);
                    SCPBallot.encode(stream, encodedSCPStatementPrepare.prepared);
                } else {
                    stream.writeInt(0);
                }
                if (encodedSCPStatementPrepare.preparedPrime != null) {
                    stream.writeInt(1);
                    SCPBallot.encode(stream, encodedSCPStatementPrepare.preparedPrime);
                } else {
                    stream.writeInt(0);
                }
                Uint32.encode(stream, encodedSCPStatementPrepare.nC);
                Uint32.encode(stream, encodedSCPStatementPrepare.nH);
            }

            public void encode(XdrDataOutputStream stream) throws IOException {
                SCPStatementPrepare.encode(stream, this);
            }

            public static SCPStatementPrepare decode(XdrDataInputStream stream) throws IOException {
                int preparedPrimePresent;
                SCPStatementPrepare decodedSCPStatementPrepare = new SCPStatementPrepare();
                decodedSCPStatementPrepare.quorumSetHash = Hash.decode(stream);
                decodedSCPStatementPrepare.ballot = SCPBallot.decode(stream);
                int preparedPresent = stream.readInt();
                if (preparedPresent != 0) {
                    decodedSCPStatementPrepare.prepared = SCPBallot.decode(stream);
                }
                if ((preparedPrimePresent = stream.readInt()) != 0) {
                    decodedSCPStatementPrepare.preparedPrime = SCPBallot.decode(stream);
                }
                decodedSCPStatementPrepare.nC = Uint32.decode(stream);
                decodedSCPStatementPrepare.nH = Uint32.decode(stream);
                return decodedSCPStatementPrepare;
            }

            public int hashCode() {
                return Objects.hashCode(this.quorumSetHash, this.ballot, this.prepared, this.preparedPrime, this.nC, this.nH);
            }

            public boolean equals(Object object) {
                if (object == null || !(object instanceof SCPStatementPrepare)) {
                    return false;
                }
                SCPStatementPrepare other = (SCPStatementPrepare)object;
                return Objects.equal(this.quorumSetHash, other.quorumSetHash) && Objects.equal(this.ballot, other.ballot) && Objects.equal(this.prepared, other.prepared) && Objects.equal(this.preparedPrime, other.preparedPrime) && Objects.equal(this.nC, other.nC) && Objects.equal(this.nH, other.nH);
            }
        }
    }
}

