/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum PaymentResultCode implements XdrElement
{
    PAYMENT_SUCCESS(0),
    PAYMENT_MALFORMED(-1),
    PAYMENT_UNDERFUNDED(-2),
    PAYMENT_SRC_NO_TRUST(-3),
    PAYMENT_SRC_NOT_AUTHORIZED(-4),
    PAYMENT_NO_DESTINATION(-5),
    PAYMENT_NO_TRUST(-6),
    PAYMENT_NOT_AUTHORIZED(-7),
    PAYMENT_LINE_FULL(-8),
    PAYMENT_NO_ISSUER(-9);

    private int mValue;

    private PaymentResultCode(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static PaymentResultCode decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return PAYMENT_SUCCESS;
            }
            case -1: {
                return PAYMENT_MALFORMED;
            }
            case -2: {
                return PAYMENT_UNDERFUNDED;
            }
            case -3: {
                return PAYMENT_SRC_NO_TRUST;
            }
            case -4: {
                return PAYMENT_SRC_NOT_AUTHORIZED;
            }
            case -5: {
                return PAYMENT_NO_DESTINATION;
            }
            case -6: {
                return PAYMENT_NO_TRUST;
            }
            case -7: {
                return PAYMENT_NOT_AUTHORIZED;
            }
            case -8: {
                return PAYMENT_LINE_FULL;
            }
            case -9: {
                return PAYMENT_NO_ISSUER;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, PaymentResultCode value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        PaymentResultCode.encode(stream, this);
    }
}

