/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.MuxedAccount;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class PaymentOp
implements XdrElement {
    private MuxedAccount destination;
    private Asset asset;
    private Int64 amount;

    public MuxedAccount getDestination() {
        return this.destination;
    }

    public void setDestination(MuxedAccount value) {
        this.destination = value;
    }

    public Asset getAsset() {
        return this.asset;
    }

    public void setAsset(Asset value) {
        this.asset = value;
    }

    public Int64 getAmount() {
        return this.amount;
    }

    public void setAmount(Int64 value) {
        this.amount = value;
    }

    public static void encode(XdrDataOutputStream stream, PaymentOp encodedPaymentOp) throws IOException {
        MuxedAccount.encode(stream, encodedPaymentOp.destination);
        Asset.encode(stream, encodedPaymentOp.asset);
        Int64.encode(stream, encodedPaymentOp.amount);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        PaymentOp.encode(stream, this);
    }

    public static PaymentOp decode(XdrDataInputStream stream) throws IOException {
        PaymentOp decodedPaymentOp = new PaymentOp();
        decodedPaymentOp.destination = MuxedAccount.decode(stream);
        decodedPaymentOp.asset = Asset.decode(stream);
        decodedPaymentOp.amount = Int64.decode(stream);
        return decodedPaymentOp;
    }

    public int hashCode() {
        return Objects.hashCode(this.destination, this.asset, this.amount);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof PaymentOp)) {
            return false;
        }
        PaymentOp other = (PaymentOp)object;
        return Objects.equal(this.destination, other.destination) && Objects.equal(this.asset, other.asset) && Objects.equal(this.amount, other.amount);
    }
}

