/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import java.util.Arrays;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.ClaimOfferAtom;
import org.stellar.sdk.xdr.PathPaymentStrictSendResultCode;
import org.stellar.sdk.xdr.SimplePaymentResult;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class PathPaymentStrictSendResult
implements XdrElement {
    PathPaymentStrictSendResultCode code;
    private PathPaymentStrictSendResultSuccess success;
    private Asset noIssuer;

    public PathPaymentStrictSendResultCode getDiscriminant() {
        return this.code;
    }

    public void setDiscriminant(PathPaymentStrictSendResultCode value) {
        this.code = value;
    }

    public PathPaymentStrictSendResultSuccess getSuccess() {
        return this.success;
    }

    public void setSuccess(PathPaymentStrictSendResultSuccess value) {
        this.success = value;
    }

    public Asset getNoIssuer() {
        return this.noIssuer;
    }

    public void setNoIssuer(Asset value) {
        this.noIssuer = value;
    }

    public static void encode(XdrDataOutputStream stream, PathPaymentStrictSendResult encodedPathPaymentStrictSendResult) throws IOException {
        stream.writeInt(encodedPathPaymentStrictSendResult.getDiscriminant().getValue());
        switch (encodedPathPaymentStrictSendResult.getDiscriminant()) {
            case PATH_PAYMENT_STRICT_SEND_SUCCESS: {
                PathPaymentStrictSendResultSuccess.encode(stream, encodedPathPaymentStrictSendResult.success);
                break;
            }
            case PATH_PAYMENT_STRICT_SEND_NO_ISSUER: {
                Asset.encode(stream, encodedPathPaymentStrictSendResult.noIssuer);
                break;
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        PathPaymentStrictSendResult.encode(stream, this);
    }

    public static PathPaymentStrictSendResult decode(XdrDataInputStream stream) throws IOException {
        PathPaymentStrictSendResult decodedPathPaymentStrictSendResult = new PathPaymentStrictSendResult();
        PathPaymentStrictSendResultCode discriminant = PathPaymentStrictSendResultCode.decode(stream);
        decodedPathPaymentStrictSendResult.setDiscriminant(discriminant);
        switch (decodedPathPaymentStrictSendResult.getDiscriminant()) {
            case PATH_PAYMENT_STRICT_SEND_SUCCESS: {
                decodedPathPaymentStrictSendResult.success = PathPaymentStrictSendResultSuccess.decode(stream);
                break;
            }
            case PATH_PAYMENT_STRICT_SEND_NO_ISSUER: {
                decodedPathPaymentStrictSendResult.noIssuer = Asset.decode(stream);
                break;
            }
        }
        return decodedPathPaymentStrictSendResult;
    }

    public int hashCode() {
        return Objects.hashCode(this.success, this.noIssuer, this.code);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof PathPaymentStrictSendResult)) {
            return false;
        }
        PathPaymentStrictSendResult other = (PathPaymentStrictSendResult)object;
        return Objects.equal(this.success, other.success) && Objects.equal(this.noIssuer, other.noIssuer) && Objects.equal(this.code, other.code);
    }

    public static class PathPaymentStrictSendResultSuccess {
        private ClaimOfferAtom[] offers;
        private SimplePaymentResult last;

        public ClaimOfferAtom[] getOffers() {
            return this.offers;
        }

        public void setOffers(ClaimOfferAtom[] value) {
            this.offers = value;
        }

        public SimplePaymentResult getLast() {
            return this.last;
        }

        public void setLast(SimplePaymentResult value) {
            this.last = value;
        }

        public static void encode(XdrDataOutputStream stream, PathPaymentStrictSendResultSuccess encodedPathPaymentStrictSendResultSuccess) throws IOException {
            int offerssize = encodedPathPaymentStrictSendResultSuccess.getOffers().length;
            stream.writeInt(offerssize);
            for (int i = 0; i < offerssize; ++i) {
                ClaimOfferAtom.encode(stream, encodedPathPaymentStrictSendResultSuccess.offers[i]);
            }
            SimplePaymentResult.encode(stream, encodedPathPaymentStrictSendResultSuccess.last);
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            PathPaymentStrictSendResultSuccess.encode(stream, this);
        }

        public static PathPaymentStrictSendResultSuccess decode(XdrDataInputStream stream) throws IOException {
            PathPaymentStrictSendResultSuccess decodedPathPaymentStrictSendResultSuccess = new PathPaymentStrictSendResultSuccess();
            int offerssize = stream.readInt();
            decodedPathPaymentStrictSendResultSuccess.offers = new ClaimOfferAtom[offerssize];
            for (int i = 0; i < offerssize; ++i) {
                decodedPathPaymentStrictSendResultSuccess.offers[i] = ClaimOfferAtom.decode(stream);
            }
            decodedPathPaymentStrictSendResultSuccess.last = SimplePaymentResult.decode(stream);
            return decodedPathPaymentStrictSendResultSuccess;
        }

        public int hashCode() {
            return Objects.hashCode(Arrays.hashCode(this.offers), this.last);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof PathPaymentStrictSendResultSuccess)) {
                return false;
            }
            PathPaymentStrictSendResultSuccess other = (PathPaymentStrictSendResultSuccess)object;
            return Arrays.equals(this.offers, other.offers) && Objects.equal(this.last, other.last);
        }
    }
}

