/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import java.util.Arrays;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.MuxedAccount;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class PathPaymentStrictSendOp
implements XdrElement {
    private Asset sendAsset;
    private Int64 sendAmount;
    private MuxedAccount destination;
    private Asset destAsset;
    private Int64 destMin;
    private Asset[] path;

    public Asset getSendAsset() {
        return this.sendAsset;
    }

    public void setSendAsset(Asset value) {
        this.sendAsset = value;
    }

    public Int64 getSendAmount() {
        return this.sendAmount;
    }

    public void setSendAmount(Int64 value) {
        this.sendAmount = value;
    }

    public MuxedAccount getDestination() {
        return this.destination;
    }

    public void setDestination(MuxedAccount value) {
        this.destination = value;
    }

    public Asset getDestAsset() {
        return this.destAsset;
    }

    public void setDestAsset(Asset value) {
        this.destAsset = value;
    }

    public Int64 getDestMin() {
        return this.destMin;
    }

    public void setDestMin(Int64 value) {
        this.destMin = value;
    }

    public Asset[] getPath() {
        return this.path;
    }

    public void setPath(Asset[] value) {
        this.path = value;
    }

    public static void encode(XdrDataOutputStream stream, PathPaymentStrictSendOp encodedPathPaymentStrictSendOp) throws IOException {
        Asset.encode(stream, encodedPathPaymentStrictSendOp.sendAsset);
        Int64.encode(stream, encodedPathPaymentStrictSendOp.sendAmount);
        MuxedAccount.encode(stream, encodedPathPaymentStrictSendOp.destination);
        Asset.encode(stream, encodedPathPaymentStrictSendOp.destAsset);
        Int64.encode(stream, encodedPathPaymentStrictSendOp.destMin);
        int pathsize = encodedPathPaymentStrictSendOp.getPath().length;
        stream.writeInt(pathsize);
        for (int i = 0; i < pathsize; ++i) {
            Asset.encode(stream, encodedPathPaymentStrictSendOp.path[i]);
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        PathPaymentStrictSendOp.encode(stream, this);
    }

    public static PathPaymentStrictSendOp decode(XdrDataInputStream stream) throws IOException {
        PathPaymentStrictSendOp decodedPathPaymentStrictSendOp = new PathPaymentStrictSendOp();
        decodedPathPaymentStrictSendOp.sendAsset = Asset.decode(stream);
        decodedPathPaymentStrictSendOp.sendAmount = Int64.decode(stream);
        decodedPathPaymentStrictSendOp.destination = MuxedAccount.decode(stream);
        decodedPathPaymentStrictSendOp.destAsset = Asset.decode(stream);
        decodedPathPaymentStrictSendOp.destMin = Int64.decode(stream);
        int pathsize = stream.readInt();
        decodedPathPaymentStrictSendOp.path = new Asset[pathsize];
        for (int i = 0; i < pathsize; ++i) {
            decodedPathPaymentStrictSendOp.path[i] = Asset.decode(stream);
        }
        return decodedPathPaymentStrictSendOp;
    }

    public int hashCode() {
        return Objects.hashCode(this.sendAsset, this.sendAmount, this.destination, this.destAsset, this.destMin, Arrays.hashCode(this.path));
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof PathPaymentStrictSendOp)) {
            return false;
        }
        PathPaymentStrictSendOp other = (PathPaymentStrictSendOp)object;
        return Objects.equal(this.sendAsset, other.sendAsset) && Objects.equal(this.sendAmount, other.sendAmount) && Objects.equal(this.destination, other.destination) && Objects.equal(this.destAsset, other.destAsset) && Objects.equal(this.destMin, other.destMin) && Arrays.equals(this.path, other.path);
    }
}

