/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import java.util.Arrays;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.ClaimOfferAtom;
import org.stellar.sdk.xdr.PathPaymentResultCode;
import org.stellar.sdk.xdr.SimplePaymentResult;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import shadow.com.google.common.base.Objects;

public class PathPaymentResult {
    PathPaymentResultCode code;
    private PathPaymentResultSuccess success;
    private Asset noIssuer;

    public PathPaymentResultCode getDiscriminant() {
        return this.code;
    }

    public void setDiscriminant(PathPaymentResultCode value) {
        this.code = value;
    }

    public PathPaymentResultSuccess getSuccess() {
        return this.success;
    }

    public void setSuccess(PathPaymentResultSuccess value) {
        this.success = value;
    }

    public Asset getNoIssuer() {
        return this.noIssuer;
    }

    public void setNoIssuer(Asset value) {
        this.noIssuer = value;
    }

    public static void encode(XdrDataOutputStream stream, PathPaymentResult encodedPathPaymentResult) throws IOException {
        stream.writeInt(encodedPathPaymentResult.getDiscriminant().getValue());
        switch (encodedPathPaymentResult.getDiscriminant()) {
            case PATH_PAYMENT_SUCCESS: {
                PathPaymentResultSuccess.encode(stream, encodedPathPaymentResult.success);
                break;
            }
            case PATH_PAYMENT_NO_ISSUER: {
                Asset.encode(stream, encodedPathPaymentResult.noIssuer);
                break;
            }
        }
    }

    public static PathPaymentResult decode(XdrDataInputStream stream) throws IOException {
        PathPaymentResult decodedPathPaymentResult = new PathPaymentResult();
        PathPaymentResultCode discriminant = PathPaymentResultCode.decode(stream);
        decodedPathPaymentResult.setDiscriminant(discriminant);
        switch (decodedPathPaymentResult.getDiscriminant()) {
            case PATH_PAYMENT_SUCCESS: {
                decodedPathPaymentResult.success = PathPaymentResultSuccess.decode(stream);
                break;
            }
            case PATH_PAYMENT_NO_ISSUER: {
                decodedPathPaymentResult.noIssuer = Asset.decode(stream);
                break;
            }
        }
        return decodedPathPaymentResult;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.success, this.noIssuer, this.code});
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof PathPaymentResult)) {
            return false;
        }
        PathPaymentResult other = (PathPaymentResult)object;
        return Objects.equal(this.success, other.success) && Objects.equal(this.noIssuer, other.noIssuer) && Objects.equal((Object)this.code, (Object)other.code);
    }

    public static class PathPaymentResultSuccess {
        private ClaimOfferAtom[] offers;
        private SimplePaymentResult last;

        public ClaimOfferAtom[] getOffers() {
            return this.offers;
        }

        public void setOffers(ClaimOfferAtom[] value) {
            this.offers = value;
        }

        public SimplePaymentResult getLast() {
            return this.last;
        }

        public void setLast(SimplePaymentResult value) {
            this.last = value;
        }

        public static void encode(XdrDataOutputStream stream, PathPaymentResultSuccess encodedPathPaymentResultSuccess) throws IOException {
            int offerssize = encodedPathPaymentResultSuccess.getOffers().length;
            stream.writeInt(offerssize);
            for (int i = 0; i < offerssize; ++i) {
                ClaimOfferAtom.encode(stream, encodedPathPaymentResultSuccess.offers[i]);
            }
            SimplePaymentResult.encode(stream, encodedPathPaymentResultSuccess.last);
        }

        public static PathPaymentResultSuccess decode(XdrDataInputStream stream) throws IOException {
            PathPaymentResultSuccess decodedPathPaymentResultSuccess = new PathPaymentResultSuccess();
            int offerssize = stream.readInt();
            decodedPathPaymentResultSuccess.offers = new ClaimOfferAtom[offerssize];
            for (int i = 0; i < offerssize; ++i) {
                decodedPathPaymentResultSuccess.offers[i] = ClaimOfferAtom.decode(stream);
            }
            decodedPathPaymentResultSuccess.last = SimplePaymentResult.decode(stream);
            return decodedPathPaymentResultSuccess;
        }

        public int hashCode() {
            return Objects.hashCode(Arrays.hashCode(this.offers), this.last);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof PathPaymentResultSuccess)) {
                return false;
            }
            PathPaymentResultSuccess other = (PathPaymentResultSuccess)object;
            return Arrays.equals(this.offers, other.offers) && Objects.equal(this.last, other.last);
        }
    }
}

