/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.AccountMergeResult;
import org.stellar.sdk.xdr.AllowTrustResult;
import org.stellar.sdk.xdr.BeginSponsoringFutureReservesResult;
import org.stellar.sdk.xdr.BumpSequenceResult;
import org.stellar.sdk.xdr.ChangeTrustResult;
import org.stellar.sdk.xdr.ClaimClaimableBalanceResult;
import org.stellar.sdk.xdr.CreateAccountResult;
import org.stellar.sdk.xdr.CreateClaimableBalanceResult;
import org.stellar.sdk.xdr.EndSponsoringFutureReservesResult;
import org.stellar.sdk.xdr.InflationResult;
import org.stellar.sdk.xdr.ManageBuyOfferResult;
import org.stellar.sdk.xdr.ManageDataResult;
import org.stellar.sdk.xdr.ManageSellOfferResult;
import org.stellar.sdk.xdr.OperationResultCode;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.PathPaymentStrictReceiveResult;
import org.stellar.sdk.xdr.PathPaymentStrictSendResult;
import org.stellar.sdk.xdr.PaymentResult;
import org.stellar.sdk.xdr.RevokeSponsorshipResult;
import org.stellar.sdk.xdr.SetOptionsResult;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class OperationResult
implements XdrElement {
    OperationResultCode code;
    private OperationResultTr tr;

    public OperationResultCode getDiscriminant() {
        return this.code;
    }

    public void setDiscriminant(OperationResultCode value) {
        this.code = value;
    }

    public OperationResultTr getTr() {
        return this.tr;
    }

    public void setTr(OperationResultTr value) {
        this.tr = value;
    }

    public static void encode(XdrDataOutputStream stream, OperationResult encodedOperationResult) throws IOException {
        stream.writeInt(encodedOperationResult.getDiscriminant().getValue());
        switch (encodedOperationResult.getDiscriminant()) {
            case opINNER: {
                OperationResultTr.encode(stream, encodedOperationResult.tr);
                break;
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        OperationResult.encode(stream, this);
    }

    public static OperationResult decode(XdrDataInputStream stream) throws IOException {
        OperationResult decodedOperationResult = new OperationResult();
        OperationResultCode discriminant = OperationResultCode.decode(stream);
        decodedOperationResult.setDiscriminant(discriminant);
        switch (decodedOperationResult.getDiscriminant()) {
            case opINNER: {
                decodedOperationResult.tr = OperationResultTr.decode(stream);
                break;
            }
        }
        return decodedOperationResult;
    }

    public int hashCode() {
        return Objects.hashCode(this.tr, this.code);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof OperationResult)) {
            return false;
        }
        OperationResult other = (OperationResult)object;
        return Objects.equal(this.tr, other.tr) && Objects.equal(this.code, other.code);
    }

    public static class OperationResultTr {
        OperationType type;
        private CreateAccountResult createAccountResult;
        private PaymentResult paymentResult;
        private PathPaymentStrictReceiveResult pathPaymentStrictReceiveResult;
        private ManageSellOfferResult manageSellOfferResult;
        private ManageSellOfferResult createPassiveSellOfferResult;
        private SetOptionsResult setOptionsResult;
        private ChangeTrustResult changeTrustResult;
        private AllowTrustResult allowTrustResult;
        private AccountMergeResult accountMergeResult;
        private InflationResult inflationResult;
        private ManageDataResult manageDataResult;
        private BumpSequenceResult bumpSeqResult;
        private ManageBuyOfferResult manageBuyOfferResult;
        private PathPaymentStrictSendResult pathPaymentStrictSendResult;
        private CreateClaimableBalanceResult createClaimableBalanceResult;
        private ClaimClaimableBalanceResult claimClaimableBalanceResult;
        private BeginSponsoringFutureReservesResult beginSponsoringFutureReservesResult;
        private EndSponsoringFutureReservesResult endSponsoringFutureReservesResult;
        private RevokeSponsorshipResult revokeSponsorshipResult;

        public OperationType getDiscriminant() {
            return this.type;
        }

        public void setDiscriminant(OperationType value) {
            this.type = value;
        }

        public CreateAccountResult getCreateAccountResult() {
            return this.createAccountResult;
        }

        public void setCreateAccountResult(CreateAccountResult value) {
            this.createAccountResult = value;
        }

        public PaymentResult getPaymentResult() {
            return this.paymentResult;
        }

        public void setPaymentResult(PaymentResult value) {
            this.paymentResult = value;
        }

        public PathPaymentStrictReceiveResult getPathPaymentStrictReceiveResult() {
            return this.pathPaymentStrictReceiveResult;
        }

        public void setPathPaymentStrictReceiveResult(PathPaymentStrictReceiveResult value) {
            this.pathPaymentStrictReceiveResult = value;
        }

        public ManageSellOfferResult getManageSellOfferResult() {
            return this.manageSellOfferResult;
        }

        public void setManageSellOfferResult(ManageSellOfferResult value) {
            this.manageSellOfferResult = value;
        }

        public ManageSellOfferResult getCreatePassiveSellOfferResult() {
            return this.createPassiveSellOfferResult;
        }

        public void setCreatePassiveSellOfferResult(ManageSellOfferResult value) {
            this.createPassiveSellOfferResult = value;
        }

        public SetOptionsResult getSetOptionsResult() {
            return this.setOptionsResult;
        }

        public void setSetOptionsResult(SetOptionsResult value) {
            this.setOptionsResult = value;
        }

        public ChangeTrustResult getChangeTrustResult() {
            return this.changeTrustResult;
        }

        public void setChangeTrustResult(ChangeTrustResult value) {
            this.changeTrustResult = value;
        }

        public AllowTrustResult getAllowTrustResult() {
            return this.allowTrustResult;
        }

        public void setAllowTrustResult(AllowTrustResult value) {
            this.allowTrustResult = value;
        }

        public AccountMergeResult getAccountMergeResult() {
            return this.accountMergeResult;
        }

        public void setAccountMergeResult(AccountMergeResult value) {
            this.accountMergeResult = value;
        }

        public InflationResult getInflationResult() {
            return this.inflationResult;
        }

        public void setInflationResult(InflationResult value) {
            this.inflationResult = value;
        }

        public ManageDataResult getManageDataResult() {
            return this.manageDataResult;
        }

        public void setManageDataResult(ManageDataResult value) {
            this.manageDataResult = value;
        }

        public BumpSequenceResult getBumpSeqResult() {
            return this.bumpSeqResult;
        }

        public void setBumpSeqResult(BumpSequenceResult value) {
            this.bumpSeqResult = value;
        }

        public ManageBuyOfferResult getManageBuyOfferResult() {
            return this.manageBuyOfferResult;
        }

        public void setManageBuyOfferResult(ManageBuyOfferResult value) {
            this.manageBuyOfferResult = value;
        }

        public PathPaymentStrictSendResult getPathPaymentStrictSendResult() {
            return this.pathPaymentStrictSendResult;
        }

        public void setPathPaymentStrictSendResult(PathPaymentStrictSendResult value) {
            this.pathPaymentStrictSendResult = value;
        }

        public CreateClaimableBalanceResult getCreateClaimableBalanceResult() {
            return this.createClaimableBalanceResult;
        }

        public void setCreateClaimableBalanceResult(CreateClaimableBalanceResult value) {
            this.createClaimableBalanceResult = value;
        }

        public ClaimClaimableBalanceResult getClaimClaimableBalanceResult() {
            return this.claimClaimableBalanceResult;
        }

        public void setClaimClaimableBalanceResult(ClaimClaimableBalanceResult value) {
            this.claimClaimableBalanceResult = value;
        }

        public BeginSponsoringFutureReservesResult getBeginSponsoringFutureReservesResult() {
            return this.beginSponsoringFutureReservesResult;
        }

        public void setBeginSponsoringFutureReservesResult(BeginSponsoringFutureReservesResult value) {
            this.beginSponsoringFutureReservesResult = value;
        }

        public EndSponsoringFutureReservesResult getEndSponsoringFutureReservesResult() {
            return this.endSponsoringFutureReservesResult;
        }

        public void setEndSponsoringFutureReservesResult(EndSponsoringFutureReservesResult value) {
            this.endSponsoringFutureReservesResult = value;
        }

        public RevokeSponsorshipResult getRevokeSponsorshipResult() {
            return this.revokeSponsorshipResult;
        }

        public void setRevokeSponsorshipResult(RevokeSponsorshipResult value) {
            this.revokeSponsorshipResult = value;
        }

        public static void encode(XdrDataOutputStream stream, OperationResultTr encodedOperationResultTr) throws IOException {
            stream.writeInt(encodedOperationResultTr.getDiscriminant().getValue());
            switch (encodedOperationResultTr.getDiscriminant()) {
                case CREATE_ACCOUNT: {
                    CreateAccountResult.encode(stream, encodedOperationResultTr.createAccountResult);
                    break;
                }
                case PAYMENT: {
                    PaymentResult.encode(stream, encodedOperationResultTr.paymentResult);
                    break;
                }
                case PATH_PAYMENT_STRICT_RECEIVE: {
                    PathPaymentStrictReceiveResult.encode(stream, encodedOperationResultTr.pathPaymentStrictReceiveResult);
                    break;
                }
                case MANAGE_SELL_OFFER: {
                    ManageSellOfferResult.encode(stream, encodedOperationResultTr.manageSellOfferResult);
                    break;
                }
                case CREATE_PASSIVE_SELL_OFFER: {
                    ManageSellOfferResult.encode(stream, encodedOperationResultTr.createPassiveSellOfferResult);
                    break;
                }
                case SET_OPTIONS: {
                    SetOptionsResult.encode(stream, encodedOperationResultTr.setOptionsResult);
                    break;
                }
                case CHANGE_TRUST: {
                    ChangeTrustResult.encode(stream, encodedOperationResultTr.changeTrustResult);
                    break;
                }
                case ALLOW_TRUST: {
                    AllowTrustResult.encode(stream, encodedOperationResultTr.allowTrustResult);
                    break;
                }
                case ACCOUNT_MERGE: {
                    AccountMergeResult.encode(stream, encodedOperationResultTr.accountMergeResult);
                    break;
                }
                case INFLATION: {
                    InflationResult.encode(stream, encodedOperationResultTr.inflationResult);
                    break;
                }
                case MANAGE_DATA: {
                    ManageDataResult.encode(stream, encodedOperationResultTr.manageDataResult);
                    break;
                }
                case BUMP_SEQUENCE: {
                    BumpSequenceResult.encode(stream, encodedOperationResultTr.bumpSeqResult);
                    break;
                }
                case MANAGE_BUY_OFFER: {
                    ManageBuyOfferResult.encode(stream, encodedOperationResultTr.manageBuyOfferResult);
                    break;
                }
                case PATH_PAYMENT_STRICT_SEND: {
                    PathPaymentStrictSendResult.encode(stream, encodedOperationResultTr.pathPaymentStrictSendResult);
                    break;
                }
                case CREATE_CLAIMABLE_BALANCE: {
                    CreateClaimableBalanceResult.encode(stream, encodedOperationResultTr.createClaimableBalanceResult);
                    break;
                }
                case CLAIM_CLAIMABLE_BALANCE: {
                    ClaimClaimableBalanceResult.encode(stream, encodedOperationResultTr.claimClaimableBalanceResult);
                    break;
                }
                case BEGIN_SPONSORING_FUTURE_RESERVES: {
                    BeginSponsoringFutureReservesResult.encode(stream, encodedOperationResultTr.beginSponsoringFutureReservesResult);
                    break;
                }
                case END_SPONSORING_FUTURE_RESERVES: {
                    EndSponsoringFutureReservesResult.encode(stream, encodedOperationResultTr.endSponsoringFutureReservesResult);
                    break;
                }
                case REVOKE_SPONSORSHIP: {
                    RevokeSponsorshipResult.encode(stream, encodedOperationResultTr.revokeSponsorshipResult);
                }
            }
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            OperationResultTr.encode(stream, this);
        }

        public static OperationResultTr decode(XdrDataInputStream stream) throws IOException {
            OperationResultTr decodedOperationResultTr = new OperationResultTr();
            OperationType discriminant = OperationType.decode(stream);
            decodedOperationResultTr.setDiscriminant(discriminant);
            switch (decodedOperationResultTr.getDiscriminant()) {
                case CREATE_ACCOUNT: {
                    decodedOperationResultTr.createAccountResult = CreateAccountResult.decode(stream);
                    break;
                }
                case PAYMENT: {
                    decodedOperationResultTr.paymentResult = PaymentResult.decode(stream);
                    break;
                }
                case PATH_PAYMENT_STRICT_RECEIVE: {
                    decodedOperationResultTr.pathPaymentStrictReceiveResult = PathPaymentStrictReceiveResult.decode(stream);
                    break;
                }
                case MANAGE_SELL_OFFER: {
                    decodedOperationResultTr.manageSellOfferResult = ManageSellOfferResult.decode(stream);
                    break;
                }
                case CREATE_PASSIVE_SELL_OFFER: {
                    decodedOperationResultTr.createPassiveSellOfferResult = ManageSellOfferResult.decode(stream);
                    break;
                }
                case SET_OPTIONS: {
                    decodedOperationResultTr.setOptionsResult = SetOptionsResult.decode(stream);
                    break;
                }
                case CHANGE_TRUST: {
                    decodedOperationResultTr.changeTrustResult = ChangeTrustResult.decode(stream);
                    break;
                }
                case ALLOW_TRUST: {
                    decodedOperationResultTr.allowTrustResult = AllowTrustResult.decode(stream);
                    break;
                }
                case ACCOUNT_MERGE: {
                    decodedOperationResultTr.accountMergeResult = AccountMergeResult.decode(stream);
                    break;
                }
                case INFLATION: {
                    decodedOperationResultTr.inflationResult = InflationResult.decode(stream);
                    break;
                }
                case MANAGE_DATA: {
                    decodedOperationResultTr.manageDataResult = ManageDataResult.decode(stream);
                    break;
                }
                case BUMP_SEQUENCE: {
                    decodedOperationResultTr.bumpSeqResult = BumpSequenceResult.decode(stream);
                    break;
                }
                case MANAGE_BUY_OFFER: {
                    decodedOperationResultTr.manageBuyOfferResult = ManageBuyOfferResult.decode(stream);
                    break;
                }
                case PATH_PAYMENT_STRICT_SEND: {
                    decodedOperationResultTr.pathPaymentStrictSendResult = PathPaymentStrictSendResult.decode(stream);
                    break;
                }
                case CREATE_CLAIMABLE_BALANCE: {
                    decodedOperationResultTr.createClaimableBalanceResult = CreateClaimableBalanceResult.decode(stream);
                    break;
                }
                case CLAIM_CLAIMABLE_BALANCE: {
                    decodedOperationResultTr.claimClaimableBalanceResult = ClaimClaimableBalanceResult.decode(stream);
                    break;
                }
                case BEGIN_SPONSORING_FUTURE_RESERVES: {
                    decodedOperationResultTr.beginSponsoringFutureReservesResult = BeginSponsoringFutureReservesResult.decode(stream);
                    break;
                }
                case END_SPONSORING_FUTURE_RESERVES: {
                    decodedOperationResultTr.endSponsoringFutureReservesResult = EndSponsoringFutureReservesResult.decode(stream);
                    break;
                }
                case REVOKE_SPONSORSHIP: {
                    decodedOperationResultTr.revokeSponsorshipResult = RevokeSponsorshipResult.decode(stream);
                }
            }
            return decodedOperationResultTr;
        }

        public int hashCode() {
            return Objects.hashCode(this.createAccountResult, this.paymentResult, this.pathPaymentStrictReceiveResult, this.manageSellOfferResult, this.createPassiveSellOfferResult, this.setOptionsResult, this.changeTrustResult, this.allowTrustResult, this.accountMergeResult, this.inflationResult, this.manageDataResult, this.bumpSeqResult, this.manageBuyOfferResult, this.pathPaymentStrictSendResult, this.createClaimableBalanceResult, this.claimClaimableBalanceResult, this.beginSponsoringFutureReservesResult, this.endSponsoringFutureReservesResult, this.revokeSponsorshipResult, this.type);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof OperationResultTr)) {
                return false;
            }
            OperationResultTr other = (OperationResultTr)object;
            return Objects.equal(this.createAccountResult, other.createAccountResult) && Objects.equal(this.paymentResult, other.paymentResult) && Objects.equal(this.pathPaymentStrictReceiveResult, other.pathPaymentStrictReceiveResult) && Objects.equal(this.manageSellOfferResult, other.manageSellOfferResult) && Objects.equal(this.createPassiveSellOfferResult, other.createPassiveSellOfferResult) && Objects.equal(this.setOptionsResult, other.setOptionsResult) && Objects.equal(this.changeTrustResult, other.changeTrustResult) && Objects.equal(this.allowTrustResult, other.allowTrustResult) && Objects.equal(this.accountMergeResult, other.accountMergeResult) && Objects.equal(this.inflationResult, other.inflationResult) && Objects.equal(this.manageDataResult, other.manageDataResult) && Objects.equal(this.bumpSeqResult, other.bumpSeqResult) && Objects.equal(this.manageBuyOfferResult, other.manageBuyOfferResult) && Objects.equal(this.pathPaymentStrictSendResult, other.pathPaymentStrictSendResult) && Objects.equal(this.createClaimableBalanceResult, other.createClaimableBalanceResult) && Objects.equal(this.claimClaimableBalanceResult, other.claimClaimableBalanceResult) && Objects.equal(this.beginSponsoringFutureReservesResult, other.beginSponsoringFutureReservesResult) && Objects.equal(this.endSponsoringFutureReservesResult, other.endSponsoringFutureReservesResult) && Objects.equal(this.revokeSponsorshipResult, other.revokeSponsorshipResult) && Objects.equal(this.type, other.type);
        }
    }
}

