/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.EnvelopeType;
import org.stellar.sdk.xdr.MuxedAccount;
import org.stellar.sdk.xdr.SequenceNumber;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class OperationID
implements XdrElement {
    EnvelopeType type;
    private OperationIDId id;

    public EnvelopeType getDiscriminant() {
        return this.type;
    }

    public void setDiscriminant(EnvelopeType value) {
        this.type = value;
    }

    public OperationIDId getId() {
        return this.id;
    }

    public void setId(OperationIDId value) {
        this.id = value;
    }

    public static void encode(XdrDataOutputStream stream, OperationID encodedOperationID) throws IOException {
        stream.writeInt(encodedOperationID.getDiscriminant().getValue());
        switch (encodedOperationID.getDiscriminant()) {
            case ENVELOPE_TYPE_OP_ID: {
                OperationIDId.encode(stream, encodedOperationID.id);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        OperationID.encode(stream, this);
    }

    public static OperationID decode(XdrDataInputStream stream) throws IOException {
        OperationID decodedOperationID = new OperationID();
        EnvelopeType discriminant = EnvelopeType.decode(stream);
        decodedOperationID.setDiscriminant(discriminant);
        switch (decodedOperationID.getDiscriminant()) {
            case ENVELOPE_TYPE_OP_ID: {
                decodedOperationID.id = OperationIDId.decode(stream);
            }
        }
        return decodedOperationID;
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.type);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof OperationID)) {
            return false;
        }
        OperationID other = (OperationID)object;
        return Objects.equal(this.id, other.id) && Objects.equal(this.type, other.type);
    }

    public static class OperationIDId {
        private MuxedAccount sourceAccount;
        private SequenceNumber seqNum;
        private Uint32 opNum;

        public MuxedAccount getSourceAccount() {
            return this.sourceAccount;
        }

        public void setSourceAccount(MuxedAccount value) {
            this.sourceAccount = value;
        }

        public SequenceNumber getSeqNum() {
            return this.seqNum;
        }

        public void setSeqNum(SequenceNumber value) {
            this.seqNum = value;
        }

        public Uint32 getOpNum() {
            return this.opNum;
        }

        public void setOpNum(Uint32 value) {
            this.opNum = value;
        }

        public static void encode(XdrDataOutputStream stream, OperationIDId encodedOperationIDId) throws IOException {
            MuxedAccount.encode(stream, encodedOperationIDId.sourceAccount);
            SequenceNumber.encode(stream, encodedOperationIDId.seqNum);
            Uint32.encode(stream, encodedOperationIDId.opNum);
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            OperationIDId.encode(stream, this);
        }

        public static OperationIDId decode(XdrDataInputStream stream) throws IOException {
            OperationIDId decodedOperationIDId = new OperationIDId();
            decodedOperationIDId.sourceAccount = MuxedAccount.decode(stream);
            decodedOperationIDId.seqNum = SequenceNumber.decode(stream);
            decodedOperationIDId.opNum = Uint32.decode(stream);
            return decodedOperationIDId;
        }

        public int hashCode() {
            return Objects.hashCode(this.sourceAccount, this.seqNum, this.opNum);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof OperationIDId)) {
                return false;
            }
            OperationIDId other = (OperationIDId)object;
            return Objects.equal(this.sourceAccount, other.sourceAccount) && Objects.equal(this.seqNum, other.seqNum) && Objects.equal(this.opNum, other.opNum);
        }
    }
}

