/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.AllowTrustOp;
import org.stellar.sdk.xdr.BeginSponsoringFutureReservesOp;
import org.stellar.sdk.xdr.BumpSequenceOp;
import org.stellar.sdk.xdr.ChangeTrustOp;
import org.stellar.sdk.xdr.ClaimClaimableBalanceOp;
import org.stellar.sdk.xdr.CreateAccountOp;
import org.stellar.sdk.xdr.CreateClaimableBalanceOp;
import org.stellar.sdk.xdr.CreatePassiveSellOfferOp;
import org.stellar.sdk.xdr.ManageBuyOfferOp;
import org.stellar.sdk.xdr.ManageDataOp;
import org.stellar.sdk.xdr.ManageSellOfferOp;
import org.stellar.sdk.xdr.MuxedAccount;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.PathPaymentStrictReceiveOp;
import org.stellar.sdk.xdr.PathPaymentStrictSendOp;
import org.stellar.sdk.xdr.PaymentOp;
import org.stellar.sdk.xdr.RevokeSponsorshipOp;
import org.stellar.sdk.xdr.SetOptionsOp;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class Operation
implements XdrElement {
    private MuxedAccount sourceAccount;
    private OperationBody body;

    public MuxedAccount getSourceAccount() {
        return this.sourceAccount;
    }

    public void setSourceAccount(MuxedAccount value) {
        this.sourceAccount = value;
    }

    public OperationBody getBody() {
        return this.body;
    }

    public void setBody(OperationBody value) {
        this.body = value;
    }

    public static void encode(XdrDataOutputStream stream, Operation encodedOperation) throws IOException {
        if (encodedOperation.sourceAccount != null) {
            stream.writeInt(1);
            MuxedAccount.encode(stream, encodedOperation.sourceAccount);
        } else {
            stream.writeInt(0);
        }
        OperationBody.encode(stream, encodedOperation.body);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        Operation.encode(stream, this);
    }

    public static Operation decode(XdrDataInputStream stream) throws IOException {
        Operation decodedOperation = new Operation();
        int sourceAccountPresent = stream.readInt();
        if (sourceAccountPresent != 0) {
            decodedOperation.sourceAccount = MuxedAccount.decode(stream);
        }
        decodedOperation.body = OperationBody.decode(stream);
        return decodedOperation;
    }

    public int hashCode() {
        return Objects.hashCode(this.sourceAccount, this.body);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Operation)) {
            return false;
        }
        Operation other = (Operation)object;
        return Objects.equal(this.sourceAccount, other.sourceAccount) && Objects.equal(this.body, other.body);
    }

    public static class OperationBody {
        OperationType type;
        private CreateAccountOp createAccountOp;
        private PaymentOp paymentOp;
        private PathPaymentStrictReceiveOp pathPaymentStrictReceiveOp;
        private ManageSellOfferOp manageSellOfferOp;
        private CreatePassiveSellOfferOp createPassiveSellOfferOp;
        private SetOptionsOp setOptionsOp;
        private ChangeTrustOp changeTrustOp;
        private AllowTrustOp allowTrustOp;
        private MuxedAccount destination;
        private ManageDataOp manageDataOp;
        private BumpSequenceOp bumpSequenceOp;
        private ManageBuyOfferOp manageBuyOfferOp;
        private PathPaymentStrictSendOp pathPaymentStrictSendOp;
        private CreateClaimableBalanceOp createClaimableBalanceOp;
        private ClaimClaimableBalanceOp claimClaimableBalanceOp;
        private BeginSponsoringFutureReservesOp beginSponsoringFutureReservesOp;
        private RevokeSponsorshipOp revokeSponsorshipOp;

        public OperationType getDiscriminant() {
            return this.type;
        }

        public void setDiscriminant(OperationType value) {
            this.type = value;
        }

        public CreateAccountOp getCreateAccountOp() {
            return this.createAccountOp;
        }

        public void setCreateAccountOp(CreateAccountOp value) {
            this.createAccountOp = value;
        }

        public PaymentOp getPaymentOp() {
            return this.paymentOp;
        }

        public void setPaymentOp(PaymentOp value) {
            this.paymentOp = value;
        }

        public PathPaymentStrictReceiveOp getPathPaymentStrictReceiveOp() {
            return this.pathPaymentStrictReceiveOp;
        }

        public void setPathPaymentStrictReceiveOp(PathPaymentStrictReceiveOp value) {
            this.pathPaymentStrictReceiveOp = value;
        }

        public ManageSellOfferOp getManageSellOfferOp() {
            return this.manageSellOfferOp;
        }

        public void setManageSellOfferOp(ManageSellOfferOp value) {
            this.manageSellOfferOp = value;
        }

        public CreatePassiveSellOfferOp getCreatePassiveSellOfferOp() {
            return this.createPassiveSellOfferOp;
        }

        public void setCreatePassiveSellOfferOp(CreatePassiveSellOfferOp value) {
            this.createPassiveSellOfferOp = value;
        }

        public SetOptionsOp getSetOptionsOp() {
            return this.setOptionsOp;
        }

        public void setSetOptionsOp(SetOptionsOp value) {
            this.setOptionsOp = value;
        }

        public ChangeTrustOp getChangeTrustOp() {
            return this.changeTrustOp;
        }

        public void setChangeTrustOp(ChangeTrustOp value) {
            this.changeTrustOp = value;
        }

        public AllowTrustOp getAllowTrustOp() {
            return this.allowTrustOp;
        }

        public void setAllowTrustOp(AllowTrustOp value) {
            this.allowTrustOp = value;
        }

        public MuxedAccount getDestination() {
            return this.destination;
        }

        public void setDestination(MuxedAccount value) {
            this.destination = value;
        }

        public ManageDataOp getManageDataOp() {
            return this.manageDataOp;
        }

        public void setManageDataOp(ManageDataOp value) {
            this.manageDataOp = value;
        }

        public BumpSequenceOp getBumpSequenceOp() {
            return this.bumpSequenceOp;
        }

        public void setBumpSequenceOp(BumpSequenceOp value) {
            this.bumpSequenceOp = value;
        }

        public ManageBuyOfferOp getManageBuyOfferOp() {
            return this.manageBuyOfferOp;
        }

        public void setManageBuyOfferOp(ManageBuyOfferOp value) {
            this.manageBuyOfferOp = value;
        }

        public PathPaymentStrictSendOp getPathPaymentStrictSendOp() {
            return this.pathPaymentStrictSendOp;
        }

        public void setPathPaymentStrictSendOp(PathPaymentStrictSendOp value) {
            this.pathPaymentStrictSendOp = value;
        }

        public CreateClaimableBalanceOp getCreateClaimableBalanceOp() {
            return this.createClaimableBalanceOp;
        }

        public void setCreateClaimableBalanceOp(CreateClaimableBalanceOp value) {
            this.createClaimableBalanceOp = value;
        }

        public ClaimClaimableBalanceOp getClaimClaimableBalanceOp() {
            return this.claimClaimableBalanceOp;
        }

        public void setClaimClaimableBalanceOp(ClaimClaimableBalanceOp value) {
            this.claimClaimableBalanceOp = value;
        }

        public BeginSponsoringFutureReservesOp getBeginSponsoringFutureReservesOp() {
            return this.beginSponsoringFutureReservesOp;
        }

        public void setBeginSponsoringFutureReservesOp(BeginSponsoringFutureReservesOp value) {
            this.beginSponsoringFutureReservesOp = value;
        }

        public RevokeSponsorshipOp getRevokeSponsorshipOp() {
            return this.revokeSponsorshipOp;
        }

        public void setRevokeSponsorshipOp(RevokeSponsorshipOp value) {
            this.revokeSponsorshipOp = value;
        }

        public static void encode(XdrDataOutputStream stream, OperationBody encodedOperationBody) throws IOException {
            stream.writeInt(encodedOperationBody.getDiscriminant().getValue());
            switch (encodedOperationBody.getDiscriminant()) {
                case CREATE_ACCOUNT: {
                    CreateAccountOp.encode(stream, encodedOperationBody.createAccountOp);
                    break;
                }
                case PAYMENT: {
                    PaymentOp.encode(stream, encodedOperationBody.paymentOp);
                    break;
                }
                case PATH_PAYMENT_STRICT_RECEIVE: {
                    PathPaymentStrictReceiveOp.encode(stream, encodedOperationBody.pathPaymentStrictReceiveOp);
                    break;
                }
                case MANAGE_SELL_OFFER: {
                    ManageSellOfferOp.encode(stream, encodedOperationBody.manageSellOfferOp);
                    break;
                }
                case CREATE_PASSIVE_SELL_OFFER: {
                    CreatePassiveSellOfferOp.encode(stream, encodedOperationBody.createPassiveSellOfferOp);
                    break;
                }
                case SET_OPTIONS: {
                    SetOptionsOp.encode(stream, encodedOperationBody.setOptionsOp);
                    break;
                }
                case CHANGE_TRUST: {
                    ChangeTrustOp.encode(stream, encodedOperationBody.changeTrustOp);
                    break;
                }
                case ALLOW_TRUST: {
                    AllowTrustOp.encode(stream, encodedOperationBody.allowTrustOp);
                    break;
                }
                case ACCOUNT_MERGE: {
                    MuxedAccount.encode(stream, encodedOperationBody.destination);
                    break;
                }
                case INFLATION: {
                    break;
                }
                case MANAGE_DATA: {
                    ManageDataOp.encode(stream, encodedOperationBody.manageDataOp);
                    break;
                }
                case BUMP_SEQUENCE: {
                    BumpSequenceOp.encode(stream, encodedOperationBody.bumpSequenceOp);
                    break;
                }
                case MANAGE_BUY_OFFER: {
                    ManageBuyOfferOp.encode(stream, encodedOperationBody.manageBuyOfferOp);
                    break;
                }
                case PATH_PAYMENT_STRICT_SEND: {
                    PathPaymentStrictSendOp.encode(stream, encodedOperationBody.pathPaymentStrictSendOp);
                    break;
                }
                case CREATE_CLAIMABLE_BALANCE: {
                    CreateClaimableBalanceOp.encode(stream, encodedOperationBody.createClaimableBalanceOp);
                    break;
                }
                case CLAIM_CLAIMABLE_BALANCE: {
                    ClaimClaimableBalanceOp.encode(stream, encodedOperationBody.claimClaimableBalanceOp);
                    break;
                }
                case BEGIN_SPONSORING_FUTURE_RESERVES: {
                    BeginSponsoringFutureReservesOp.encode(stream, encodedOperationBody.beginSponsoringFutureReservesOp);
                    break;
                }
                case END_SPONSORING_FUTURE_RESERVES: {
                    break;
                }
                case REVOKE_SPONSORSHIP: {
                    RevokeSponsorshipOp.encode(stream, encodedOperationBody.revokeSponsorshipOp);
                }
            }
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            OperationBody.encode(stream, this);
        }

        public static OperationBody decode(XdrDataInputStream stream) throws IOException {
            OperationBody decodedOperationBody = new OperationBody();
            OperationType discriminant = OperationType.decode(stream);
            decodedOperationBody.setDiscriminant(discriminant);
            switch (decodedOperationBody.getDiscriminant()) {
                case CREATE_ACCOUNT: {
                    decodedOperationBody.createAccountOp = CreateAccountOp.decode(stream);
                    break;
                }
                case PAYMENT: {
                    decodedOperationBody.paymentOp = PaymentOp.decode(stream);
                    break;
                }
                case PATH_PAYMENT_STRICT_RECEIVE: {
                    decodedOperationBody.pathPaymentStrictReceiveOp = PathPaymentStrictReceiveOp.decode(stream);
                    break;
                }
                case MANAGE_SELL_OFFER: {
                    decodedOperationBody.manageSellOfferOp = ManageSellOfferOp.decode(stream);
                    break;
                }
                case CREATE_PASSIVE_SELL_OFFER: {
                    decodedOperationBody.createPassiveSellOfferOp = CreatePassiveSellOfferOp.decode(stream);
                    break;
                }
                case SET_OPTIONS: {
                    decodedOperationBody.setOptionsOp = SetOptionsOp.decode(stream);
                    break;
                }
                case CHANGE_TRUST: {
                    decodedOperationBody.changeTrustOp = ChangeTrustOp.decode(stream);
                    break;
                }
                case ALLOW_TRUST: {
                    decodedOperationBody.allowTrustOp = AllowTrustOp.decode(stream);
                    break;
                }
                case ACCOUNT_MERGE: {
                    decodedOperationBody.destination = MuxedAccount.decode(stream);
                    break;
                }
                case INFLATION: {
                    break;
                }
                case MANAGE_DATA: {
                    decodedOperationBody.manageDataOp = ManageDataOp.decode(stream);
                    break;
                }
                case BUMP_SEQUENCE: {
                    decodedOperationBody.bumpSequenceOp = BumpSequenceOp.decode(stream);
                    break;
                }
                case MANAGE_BUY_OFFER: {
                    decodedOperationBody.manageBuyOfferOp = ManageBuyOfferOp.decode(stream);
                    break;
                }
                case PATH_PAYMENT_STRICT_SEND: {
                    decodedOperationBody.pathPaymentStrictSendOp = PathPaymentStrictSendOp.decode(stream);
                    break;
                }
                case CREATE_CLAIMABLE_BALANCE: {
                    decodedOperationBody.createClaimableBalanceOp = CreateClaimableBalanceOp.decode(stream);
                    break;
                }
                case CLAIM_CLAIMABLE_BALANCE: {
                    decodedOperationBody.claimClaimableBalanceOp = ClaimClaimableBalanceOp.decode(stream);
                    break;
                }
                case BEGIN_SPONSORING_FUTURE_RESERVES: {
                    decodedOperationBody.beginSponsoringFutureReservesOp = BeginSponsoringFutureReservesOp.decode(stream);
                    break;
                }
                case END_SPONSORING_FUTURE_RESERVES: {
                    break;
                }
                case REVOKE_SPONSORSHIP: {
                    decodedOperationBody.revokeSponsorshipOp = RevokeSponsorshipOp.decode(stream);
                }
            }
            return decodedOperationBody;
        }

        public int hashCode() {
            return Objects.hashCode(this.createAccountOp, this.paymentOp, this.pathPaymentStrictReceiveOp, this.manageSellOfferOp, this.createPassiveSellOfferOp, this.setOptionsOp, this.changeTrustOp, this.allowTrustOp, this.destination, this.manageDataOp, this.bumpSequenceOp, this.manageBuyOfferOp, this.pathPaymentStrictSendOp, this.createClaimableBalanceOp, this.claimClaimableBalanceOp, this.beginSponsoringFutureReservesOp, this.revokeSponsorshipOp, this.type);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof OperationBody)) {
                return false;
            }
            OperationBody other = (OperationBody)object;
            return Objects.equal(this.createAccountOp, other.createAccountOp) && Objects.equal(this.paymentOp, other.paymentOp) && Objects.equal(this.pathPaymentStrictReceiveOp, other.pathPaymentStrictReceiveOp) && Objects.equal(this.manageSellOfferOp, other.manageSellOfferOp) && Objects.equal(this.createPassiveSellOfferOp, other.createPassiveSellOfferOp) && Objects.equal(this.setOptionsOp, other.setOptionsOp) && Objects.equal(this.changeTrustOp, other.changeTrustOp) && Objects.equal(this.allowTrustOp, other.allowTrustOp) && Objects.equal(this.destination, other.destination) && Objects.equal(this.manageDataOp, other.manageDataOp) && Objects.equal(this.bumpSequenceOp, other.bumpSequenceOp) && Objects.equal(this.manageBuyOfferOp, other.manageBuyOfferOp) && Objects.equal(this.pathPaymentStrictSendOp, other.pathPaymentStrictSendOp) && Objects.equal(this.createClaimableBalanceOp, other.createClaimableBalanceOp) && Objects.equal(this.claimClaimableBalanceOp, other.claimClaimableBalanceOp) && Objects.equal(this.beginSponsoringFutureReservesOp, other.beginSponsoringFutureReservesOp) && Objects.equal(this.revokeSponsorshipOp, other.revokeSponsorshipOp) && Objects.equal(this.type, other.type);
        }
    }
}

