/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Price;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class OfferEntry
implements XdrElement {
    private AccountID sellerID;
    private Int64 offerID;
    private Asset selling;
    private Asset buying;
    private Int64 amount;
    private Price price;
    private Uint32 flags;
    private OfferEntryExt ext;

    public AccountID getSellerID() {
        return this.sellerID;
    }

    public void setSellerID(AccountID value) {
        this.sellerID = value;
    }

    public Int64 getOfferID() {
        return this.offerID;
    }

    public void setOfferID(Int64 value) {
        this.offerID = value;
    }

    public Asset getSelling() {
        return this.selling;
    }

    public void setSelling(Asset value) {
        this.selling = value;
    }

    public Asset getBuying() {
        return this.buying;
    }

    public void setBuying(Asset value) {
        this.buying = value;
    }

    public Int64 getAmount() {
        return this.amount;
    }

    public void setAmount(Int64 value) {
        this.amount = value;
    }

    public Price getPrice() {
        return this.price;
    }

    public void setPrice(Price value) {
        this.price = value;
    }

    public Uint32 getFlags() {
        return this.flags;
    }

    public void setFlags(Uint32 value) {
        this.flags = value;
    }

    public OfferEntryExt getExt() {
        return this.ext;
    }

    public void setExt(OfferEntryExt value) {
        this.ext = value;
    }

    public static void encode(XdrDataOutputStream stream, OfferEntry encodedOfferEntry) throws IOException {
        AccountID.encode(stream, encodedOfferEntry.sellerID);
        Int64.encode(stream, encodedOfferEntry.offerID);
        Asset.encode(stream, encodedOfferEntry.selling);
        Asset.encode(stream, encodedOfferEntry.buying);
        Int64.encode(stream, encodedOfferEntry.amount);
        Price.encode(stream, encodedOfferEntry.price);
        Uint32.encode(stream, encodedOfferEntry.flags);
        OfferEntryExt.encode(stream, encodedOfferEntry.ext);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        OfferEntry.encode(stream, this);
    }

    public static OfferEntry decode(XdrDataInputStream stream) throws IOException {
        OfferEntry decodedOfferEntry = new OfferEntry();
        decodedOfferEntry.sellerID = AccountID.decode(stream);
        decodedOfferEntry.offerID = Int64.decode(stream);
        decodedOfferEntry.selling = Asset.decode(stream);
        decodedOfferEntry.buying = Asset.decode(stream);
        decodedOfferEntry.amount = Int64.decode(stream);
        decodedOfferEntry.price = Price.decode(stream);
        decodedOfferEntry.flags = Uint32.decode(stream);
        decodedOfferEntry.ext = OfferEntryExt.decode(stream);
        return decodedOfferEntry;
    }

    public int hashCode() {
        return Objects.hashCode(this.sellerID, this.offerID, this.selling, this.buying, this.amount, this.price, this.flags, this.ext);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof OfferEntry)) {
            return false;
        }
        OfferEntry other = (OfferEntry)object;
        return Objects.equal(this.sellerID, other.sellerID) && Objects.equal(this.offerID, other.offerID) && Objects.equal(this.selling, other.selling) && Objects.equal(this.buying, other.buying) && Objects.equal(this.amount, other.amount) && Objects.equal(this.price, other.price) && Objects.equal(this.flags, other.flags) && Objects.equal(this.ext, other.ext);
    }

    public static class OfferEntryExt {
        Integer v;

        public Integer getDiscriminant() {
            return this.v;
        }

        public void setDiscriminant(Integer value) {
            this.v = value;
        }

        public static void encode(XdrDataOutputStream stream, OfferEntryExt encodedOfferEntryExt) throws IOException {
            stream.writeInt(encodedOfferEntryExt.getDiscriminant());
            switch (encodedOfferEntryExt.getDiscriminant()) {
                default: 
            }
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            OfferEntryExt.encode(stream, this);
        }

        public static OfferEntryExt decode(XdrDataInputStream stream) throws IOException {
            OfferEntryExt decodedOfferEntryExt = new OfferEntryExt();
            Integer discriminant = stream.readInt();
            decodedOfferEntryExt.setDiscriminant(discriminant);
            switch (decodedOfferEntryExt.getDiscriminant()) {
                default: 
            }
            return decodedOfferEntryExt;
        }

        public int hashCode() {
            return Objects.hashCode(this.v);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof OfferEntryExt)) {
                return false;
            }
            OfferEntryExt other = (OfferEntryExt)object;
            return Objects.equal(this.v, other.v);
        }
    }
}

