/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.CryptoKeyType;
import org.stellar.sdk.xdr.Uint256;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class MuxedAccount
implements XdrElement {
    CryptoKeyType type;
    private Uint256 ed25519;
    private MuxedAccountMed25519 med25519;

    public CryptoKeyType getDiscriminant() {
        return this.type;
    }

    public void setDiscriminant(CryptoKeyType value) {
        this.type = value;
    }

    public Uint256 getEd25519() {
        return this.ed25519;
    }

    public void setEd25519(Uint256 value) {
        this.ed25519 = value;
    }

    public MuxedAccountMed25519 getMed25519() {
        return this.med25519;
    }

    public void setMed25519(MuxedAccountMed25519 value) {
        this.med25519 = value;
    }

    public static void encode(XdrDataOutputStream stream, MuxedAccount encodedMuxedAccount) throws IOException {
        stream.writeInt(encodedMuxedAccount.getDiscriminant().getValue());
        switch (encodedMuxedAccount.getDiscriminant()) {
            case KEY_TYPE_ED25519: {
                Uint256.encode(stream, encodedMuxedAccount.ed25519);
                break;
            }
            case KEY_TYPE_MUXED_ED25519: {
                MuxedAccountMed25519.encode(stream, encodedMuxedAccount.med25519);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        MuxedAccount.encode(stream, this);
    }

    public static MuxedAccount decode(XdrDataInputStream stream) throws IOException {
        MuxedAccount decodedMuxedAccount = new MuxedAccount();
        CryptoKeyType discriminant = CryptoKeyType.decode(stream);
        decodedMuxedAccount.setDiscriminant(discriminant);
        switch (decodedMuxedAccount.getDiscriminant()) {
            case KEY_TYPE_ED25519: {
                decodedMuxedAccount.ed25519 = Uint256.decode(stream);
                break;
            }
            case KEY_TYPE_MUXED_ED25519: {
                decodedMuxedAccount.med25519 = MuxedAccountMed25519.decode(stream);
            }
        }
        return decodedMuxedAccount;
    }

    public int hashCode() {
        return Objects.hashCode(this.ed25519, this.med25519, this.type);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof MuxedAccount)) {
            return false;
        }
        MuxedAccount other = (MuxedAccount)object;
        return Objects.equal(this.ed25519, other.ed25519) && Objects.equal(this.med25519, other.med25519) && Objects.equal(this.type, other.type);
    }

    public static class MuxedAccountMed25519 {
        private Uint64 id;
        private Uint256 ed25519;

        public Uint64 getId() {
            return this.id;
        }

        public void setId(Uint64 value) {
            this.id = value;
        }

        public Uint256 getEd25519() {
            return this.ed25519;
        }

        public void setEd25519(Uint256 value) {
            this.ed25519 = value;
        }

        public static void encode(XdrDataOutputStream stream, MuxedAccountMed25519 encodedMuxedAccountMed25519) throws IOException {
            Uint64.encode(stream, encodedMuxedAccountMed25519.id);
            Uint256.encode(stream, encodedMuxedAccountMed25519.ed25519);
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            MuxedAccountMed25519.encode(stream, this);
        }

        public static MuxedAccountMed25519 decode(XdrDataInputStream stream) throws IOException {
            MuxedAccountMed25519 decodedMuxedAccountMed25519 = new MuxedAccountMed25519();
            decodedMuxedAccountMed25519.id = Uint64.decode(stream);
            decodedMuxedAccountMed25519.ed25519 = Uint256.decode(stream);
            return decodedMuxedAccountMed25519;
        }

        public int hashCode() {
            return Objects.hashCode(this.id, this.ed25519);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof MuxedAccountMed25519)) {
                return false;
            }
            MuxedAccountMed25519 other = (MuxedAccountMed25519)object;
            return Objects.equal(this.id, other.id) && Objects.equal(this.ed25519, other.ed25519);
        }
    }
}

