/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import java.util.Arrays;
import org.stellar.sdk.xdr.SCPEnvelope;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class LedgerSCPMessages
implements XdrElement {
    private Uint32 ledgerSeq;
    private SCPEnvelope[] messages;

    public Uint32 getLedgerSeq() {
        return this.ledgerSeq;
    }

    public void setLedgerSeq(Uint32 value) {
        this.ledgerSeq = value;
    }

    public SCPEnvelope[] getMessages() {
        return this.messages;
    }

    public void setMessages(SCPEnvelope[] value) {
        this.messages = value;
    }

    public static void encode(XdrDataOutputStream stream, LedgerSCPMessages encodedLedgerSCPMessages) throws IOException {
        Uint32.encode(stream, encodedLedgerSCPMessages.ledgerSeq);
        int messagessize = encodedLedgerSCPMessages.getMessages().length;
        stream.writeInt(messagessize);
        for (int i = 0; i < messagessize; ++i) {
            SCPEnvelope.encode(stream, encodedLedgerSCPMessages.messages[i]);
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        LedgerSCPMessages.encode(stream, this);
    }

    public static LedgerSCPMessages decode(XdrDataInputStream stream) throws IOException {
        LedgerSCPMessages decodedLedgerSCPMessages = new LedgerSCPMessages();
        decodedLedgerSCPMessages.ledgerSeq = Uint32.decode(stream);
        int messagessize = stream.readInt();
        decodedLedgerSCPMessages.messages = new SCPEnvelope[messagessize];
        for (int i = 0; i < messagessize; ++i) {
            decodedLedgerSCPMessages.messages[i] = SCPEnvelope.decode(stream);
        }
        return decodedLedgerSCPMessages;
    }

    public int hashCode() {
        return Objects.hashCode(this.ledgerSeq, Arrays.hashCode(this.messages));
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof LedgerSCPMessages)) {
            return false;
        }
        LedgerSCPMessages other = (LedgerSCPMessages)object;
        return Objects.equal(this.ledgerSeq, other.ledgerSeq) && Arrays.equals(this.messages, other.messages);
    }
}

