/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.ClaimableBalanceID;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.LedgerEntryType;
import org.stellar.sdk.xdr.String64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class LedgerKey
implements XdrElement {
    LedgerEntryType type;
    private LedgerKeyAccount account;
    private LedgerKeyTrustLine trustLine;
    private LedgerKeyOffer offer;
    private LedgerKeyData data;
    private LedgerKeyClaimableBalance claimableBalance;

    public LedgerEntryType getDiscriminant() {
        return this.type;
    }

    public void setDiscriminant(LedgerEntryType value) {
        this.type = value;
    }

    public LedgerKeyAccount getAccount() {
        return this.account;
    }

    public void setAccount(LedgerKeyAccount value) {
        this.account = value;
    }

    public LedgerKeyTrustLine getTrustLine() {
        return this.trustLine;
    }

    public void setTrustLine(LedgerKeyTrustLine value) {
        this.trustLine = value;
    }

    public LedgerKeyOffer getOffer() {
        return this.offer;
    }

    public void setOffer(LedgerKeyOffer value) {
        this.offer = value;
    }

    public LedgerKeyData getData() {
        return this.data;
    }

    public void setData(LedgerKeyData value) {
        this.data = value;
    }

    public LedgerKeyClaimableBalance getClaimableBalance() {
        return this.claimableBalance;
    }

    public void setClaimableBalance(LedgerKeyClaimableBalance value) {
        this.claimableBalance = value;
    }

    public static void encode(XdrDataOutputStream stream, LedgerKey encodedLedgerKey) throws IOException {
        stream.writeInt(encodedLedgerKey.getDiscriminant().getValue());
        switch (encodedLedgerKey.getDiscriminant()) {
            case ACCOUNT: {
                LedgerKeyAccount.encode(stream, encodedLedgerKey.account);
                break;
            }
            case TRUSTLINE: {
                LedgerKeyTrustLine.encode(stream, encodedLedgerKey.trustLine);
                break;
            }
            case OFFER: {
                LedgerKeyOffer.encode(stream, encodedLedgerKey.offer);
                break;
            }
            case DATA: {
                LedgerKeyData.encode(stream, encodedLedgerKey.data);
                break;
            }
            case CLAIMABLE_BALANCE: {
                LedgerKeyClaimableBalance.encode(stream, encodedLedgerKey.claimableBalance);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        LedgerKey.encode(stream, this);
    }

    public static LedgerKey decode(XdrDataInputStream stream) throws IOException {
        LedgerKey decodedLedgerKey = new LedgerKey();
        LedgerEntryType discriminant = LedgerEntryType.decode(stream);
        decodedLedgerKey.setDiscriminant(discriminant);
        switch (decodedLedgerKey.getDiscriminant()) {
            case ACCOUNT: {
                decodedLedgerKey.account = LedgerKeyAccount.decode(stream);
                break;
            }
            case TRUSTLINE: {
                decodedLedgerKey.trustLine = LedgerKeyTrustLine.decode(stream);
                break;
            }
            case OFFER: {
                decodedLedgerKey.offer = LedgerKeyOffer.decode(stream);
                break;
            }
            case DATA: {
                decodedLedgerKey.data = LedgerKeyData.decode(stream);
                break;
            }
            case CLAIMABLE_BALANCE: {
                decodedLedgerKey.claimableBalance = LedgerKeyClaimableBalance.decode(stream);
            }
        }
        return decodedLedgerKey;
    }

    public int hashCode() {
        return Objects.hashCode(this.account, this.trustLine, this.offer, this.data, this.claimableBalance, this.type);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof LedgerKey)) {
            return false;
        }
        LedgerKey other = (LedgerKey)object;
        return Objects.equal(this.account, other.account) && Objects.equal(this.trustLine, other.trustLine) && Objects.equal(this.offer, other.offer) && Objects.equal(this.data, other.data) && Objects.equal(this.claimableBalance, other.claimableBalance) && Objects.equal(this.type, other.type);
    }

    public static class LedgerKeyClaimableBalance {
        private ClaimableBalanceID balanceID;

        public ClaimableBalanceID getBalanceID() {
            return this.balanceID;
        }

        public void setBalanceID(ClaimableBalanceID value) {
            this.balanceID = value;
        }

        public static void encode(XdrDataOutputStream stream, LedgerKeyClaimableBalance encodedLedgerKeyClaimableBalance) throws IOException {
            ClaimableBalanceID.encode(stream, encodedLedgerKeyClaimableBalance.balanceID);
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            LedgerKeyClaimableBalance.encode(stream, this);
        }

        public static LedgerKeyClaimableBalance decode(XdrDataInputStream stream) throws IOException {
            LedgerKeyClaimableBalance decodedLedgerKeyClaimableBalance = new LedgerKeyClaimableBalance();
            decodedLedgerKeyClaimableBalance.balanceID = ClaimableBalanceID.decode(stream);
            return decodedLedgerKeyClaimableBalance;
        }

        public int hashCode() {
            return Objects.hashCode(this.balanceID);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof LedgerKeyClaimableBalance)) {
                return false;
            }
            LedgerKeyClaimableBalance other = (LedgerKeyClaimableBalance)object;
            return Objects.equal(this.balanceID, other.balanceID);
        }
    }

    public static class LedgerKeyData {
        private AccountID accountID;
        private String64 dataName;

        public AccountID getAccountID() {
            return this.accountID;
        }

        public void setAccountID(AccountID value) {
            this.accountID = value;
        }

        public String64 getDataName() {
            return this.dataName;
        }

        public void setDataName(String64 value) {
            this.dataName = value;
        }

        public static void encode(XdrDataOutputStream stream, LedgerKeyData encodedLedgerKeyData) throws IOException {
            AccountID.encode(stream, encodedLedgerKeyData.accountID);
            String64.encode(stream, encodedLedgerKeyData.dataName);
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            LedgerKeyData.encode(stream, this);
        }

        public static LedgerKeyData decode(XdrDataInputStream stream) throws IOException {
            LedgerKeyData decodedLedgerKeyData = new LedgerKeyData();
            decodedLedgerKeyData.accountID = AccountID.decode(stream);
            decodedLedgerKeyData.dataName = String64.decode(stream);
            return decodedLedgerKeyData;
        }

        public int hashCode() {
            return Objects.hashCode(this.accountID, this.dataName);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof LedgerKeyData)) {
                return false;
            }
            LedgerKeyData other = (LedgerKeyData)object;
            return Objects.equal(this.accountID, other.accountID) && Objects.equal(this.dataName, other.dataName);
        }
    }

    public static class LedgerKeyOffer {
        private AccountID sellerID;
        private Int64 offerID;

        public AccountID getSellerID() {
            return this.sellerID;
        }

        public void setSellerID(AccountID value) {
            this.sellerID = value;
        }

        public Int64 getOfferID() {
            return this.offerID;
        }

        public void setOfferID(Int64 value) {
            this.offerID = value;
        }

        public static void encode(XdrDataOutputStream stream, LedgerKeyOffer encodedLedgerKeyOffer) throws IOException {
            AccountID.encode(stream, encodedLedgerKeyOffer.sellerID);
            Int64.encode(stream, encodedLedgerKeyOffer.offerID);
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            LedgerKeyOffer.encode(stream, this);
        }

        public static LedgerKeyOffer decode(XdrDataInputStream stream) throws IOException {
            LedgerKeyOffer decodedLedgerKeyOffer = new LedgerKeyOffer();
            decodedLedgerKeyOffer.sellerID = AccountID.decode(stream);
            decodedLedgerKeyOffer.offerID = Int64.decode(stream);
            return decodedLedgerKeyOffer;
        }

        public int hashCode() {
            return Objects.hashCode(this.sellerID, this.offerID);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof LedgerKeyOffer)) {
                return false;
            }
            LedgerKeyOffer other = (LedgerKeyOffer)object;
            return Objects.equal(this.sellerID, other.sellerID) && Objects.equal(this.offerID, other.offerID);
        }
    }

    public static class LedgerKeyTrustLine {
        private AccountID accountID;
        private Asset asset;

        public AccountID getAccountID() {
            return this.accountID;
        }

        public void setAccountID(AccountID value) {
            this.accountID = value;
        }

        public Asset getAsset() {
            return this.asset;
        }

        public void setAsset(Asset value) {
            this.asset = value;
        }

        public static void encode(XdrDataOutputStream stream, LedgerKeyTrustLine encodedLedgerKeyTrustLine) throws IOException {
            AccountID.encode(stream, encodedLedgerKeyTrustLine.accountID);
            Asset.encode(stream, encodedLedgerKeyTrustLine.asset);
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            LedgerKeyTrustLine.encode(stream, this);
        }

        public static LedgerKeyTrustLine decode(XdrDataInputStream stream) throws IOException {
            LedgerKeyTrustLine decodedLedgerKeyTrustLine = new LedgerKeyTrustLine();
            decodedLedgerKeyTrustLine.accountID = AccountID.decode(stream);
            decodedLedgerKeyTrustLine.asset = Asset.decode(stream);
            return decodedLedgerKeyTrustLine;
        }

        public int hashCode() {
            return Objects.hashCode(this.accountID, this.asset);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof LedgerKeyTrustLine)) {
                return false;
            }
            LedgerKeyTrustLine other = (LedgerKeyTrustLine)object;
            return Objects.equal(this.accountID, other.accountID) && Objects.equal(this.asset, other.asset);
        }
    }

    public static class LedgerKeyAccount {
        private AccountID accountID;

        public AccountID getAccountID() {
            return this.accountID;
        }

        public void setAccountID(AccountID value) {
            this.accountID = value;
        }

        public static void encode(XdrDataOutputStream stream, LedgerKeyAccount encodedLedgerKeyAccount) throws IOException {
            AccountID.encode(stream, encodedLedgerKeyAccount.accountID);
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            LedgerKeyAccount.encode(stream, this);
        }

        public static LedgerKeyAccount decode(XdrDataInputStream stream) throws IOException {
            LedgerKeyAccount decodedLedgerKeyAccount = new LedgerKeyAccount();
            decodedLedgerKeyAccount.accountID = AccountID.decode(stream);
            return decodedLedgerKeyAccount;
        }

        public int hashCode() {
            return Objects.hashCode(this.accountID);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof LedgerKeyAccount)) {
                return false;
            }
            LedgerKeyAccount other = (LedgerKeyAccount)object;
            return Objects.equal(this.accountID, other.accountID);
        }
    }
}

