/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.LedgerHeader;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class LedgerHeaderHistoryEntry
implements XdrElement {
    private Hash hash;
    private LedgerHeader header;
    private LedgerHeaderHistoryEntryExt ext;

    public Hash getHash() {
        return this.hash;
    }

    public void setHash(Hash value) {
        this.hash = value;
    }

    public LedgerHeader getHeader() {
        return this.header;
    }

    public void setHeader(LedgerHeader value) {
        this.header = value;
    }

    public LedgerHeaderHistoryEntryExt getExt() {
        return this.ext;
    }

    public void setExt(LedgerHeaderHistoryEntryExt value) {
        this.ext = value;
    }

    public static void encode(XdrDataOutputStream stream, LedgerHeaderHistoryEntry encodedLedgerHeaderHistoryEntry) throws IOException {
        Hash.encode(stream, encodedLedgerHeaderHistoryEntry.hash);
        LedgerHeader.encode(stream, encodedLedgerHeaderHistoryEntry.header);
        LedgerHeaderHistoryEntryExt.encode(stream, encodedLedgerHeaderHistoryEntry.ext);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        LedgerHeaderHistoryEntry.encode(stream, this);
    }

    public static LedgerHeaderHistoryEntry decode(XdrDataInputStream stream) throws IOException {
        LedgerHeaderHistoryEntry decodedLedgerHeaderHistoryEntry = new LedgerHeaderHistoryEntry();
        decodedLedgerHeaderHistoryEntry.hash = Hash.decode(stream);
        decodedLedgerHeaderHistoryEntry.header = LedgerHeader.decode(stream);
        decodedLedgerHeaderHistoryEntry.ext = LedgerHeaderHistoryEntryExt.decode(stream);
        return decodedLedgerHeaderHistoryEntry;
    }

    public int hashCode() {
        return Objects.hashCode(this.hash, this.header, this.ext);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof LedgerHeaderHistoryEntry)) {
            return false;
        }
        LedgerHeaderHistoryEntry other = (LedgerHeaderHistoryEntry)object;
        return Objects.equal(this.hash, other.hash) && Objects.equal(this.header, other.header) && Objects.equal(this.ext, other.ext);
    }

    public static class LedgerHeaderHistoryEntryExt {
        Integer v;

        public Integer getDiscriminant() {
            return this.v;
        }

        public void setDiscriminant(Integer value) {
            this.v = value;
        }

        public static void encode(XdrDataOutputStream stream, LedgerHeaderHistoryEntryExt encodedLedgerHeaderHistoryEntryExt) throws IOException {
            stream.writeInt(encodedLedgerHeaderHistoryEntryExt.getDiscriminant());
            switch (encodedLedgerHeaderHistoryEntryExt.getDiscriminant()) {
                default: 
            }
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            LedgerHeaderHistoryEntryExt.encode(stream, this);
        }

        public static LedgerHeaderHistoryEntryExt decode(XdrDataInputStream stream) throws IOException {
            LedgerHeaderHistoryEntryExt decodedLedgerHeaderHistoryEntryExt = new LedgerHeaderHistoryEntryExt();
            Integer discriminant = stream.readInt();
            decodedLedgerHeaderHistoryEntryExt.setDiscriminant(discriminant);
            switch (decodedLedgerHeaderHistoryEntryExt.getDiscriminant()) {
                default: 
            }
            return decodedLedgerHeaderHistoryEntryExt;
        }

        public int hashCode() {
            return Objects.hashCode(this.v);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof LedgerHeaderHistoryEntryExt)) {
                return false;
            }
            LedgerHeaderHistoryEntryExt other = (LedgerHeaderHistoryEntryExt)object;
            return Objects.equal(this.v, other.v);
        }
    }
}

