/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import java.util.Arrays;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.StellarValue;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class LedgerHeader
implements XdrElement {
    private Uint32 ledgerVersion;
    private Hash previousLedgerHash;
    private StellarValue scpValue;
    private Hash txSetResultHash;
    private Hash bucketListHash;
    private Uint32 ledgerSeq;
    private Int64 totalCoins;
    private Int64 feePool;
    private Uint32 inflationSeq;
    private Uint64 idPool;
    private Uint32 baseFee;
    private Uint32 baseReserve;
    private Uint32 maxTxSetSize;
    private Hash[] skipList;
    private LedgerHeaderExt ext;

    public Uint32 getLedgerVersion() {
        return this.ledgerVersion;
    }

    public void setLedgerVersion(Uint32 value) {
        this.ledgerVersion = value;
    }

    public Hash getPreviousLedgerHash() {
        return this.previousLedgerHash;
    }

    public void setPreviousLedgerHash(Hash value) {
        this.previousLedgerHash = value;
    }

    public StellarValue getScpValue() {
        return this.scpValue;
    }

    public void setScpValue(StellarValue value) {
        this.scpValue = value;
    }

    public Hash getTxSetResultHash() {
        return this.txSetResultHash;
    }

    public void setTxSetResultHash(Hash value) {
        this.txSetResultHash = value;
    }

    public Hash getBucketListHash() {
        return this.bucketListHash;
    }

    public void setBucketListHash(Hash value) {
        this.bucketListHash = value;
    }

    public Uint32 getLedgerSeq() {
        return this.ledgerSeq;
    }

    public void setLedgerSeq(Uint32 value) {
        this.ledgerSeq = value;
    }

    public Int64 getTotalCoins() {
        return this.totalCoins;
    }

    public void setTotalCoins(Int64 value) {
        this.totalCoins = value;
    }

    public Int64 getFeePool() {
        return this.feePool;
    }

    public void setFeePool(Int64 value) {
        this.feePool = value;
    }

    public Uint32 getInflationSeq() {
        return this.inflationSeq;
    }

    public void setInflationSeq(Uint32 value) {
        this.inflationSeq = value;
    }

    public Uint64 getIdPool() {
        return this.idPool;
    }

    public void setIdPool(Uint64 value) {
        this.idPool = value;
    }

    public Uint32 getBaseFee() {
        return this.baseFee;
    }

    public void setBaseFee(Uint32 value) {
        this.baseFee = value;
    }

    public Uint32 getBaseReserve() {
        return this.baseReserve;
    }

    public void setBaseReserve(Uint32 value) {
        this.baseReserve = value;
    }

    public Uint32 getMaxTxSetSize() {
        return this.maxTxSetSize;
    }

    public void setMaxTxSetSize(Uint32 value) {
        this.maxTxSetSize = value;
    }

    public Hash[] getSkipList() {
        return this.skipList;
    }

    public void setSkipList(Hash[] value) {
        this.skipList = value;
    }

    public LedgerHeaderExt getExt() {
        return this.ext;
    }

    public void setExt(LedgerHeaderExt value) {
        this.ext = value;
    }

    public static void encode(XdrDataOutputStream stream, LedgerHeader encodedLedgerHeader) throws IOException {
        Uint32.encode(stream, encodedLedgerHeader.ledgerVersion);
        Hash.encode(stream, encodedLedgerHeader.previousLedgerHash);
        StellarValue.encode(stream, encodedLedgerHeader.scpValue);
        Hash.encode(stream, encodedLedgerHeader.txSetResultHash);
        Hash.encode(stream, encodedLedgerHeader.bucketListHash);
        Uint32.encode(stream, encodedLedgerHeader.ledgerSeq);
        Int64.encode(stream, encodedLedgerHeader.totalCoins);
        Int64.encode(stream, encodedLedgerHeader.feePool);
        Uint32.encode(stream, encodedLedgerHeader.inflationSeq);
        Uint64.encode(stream, encodedLedgerHeader.idPool);
        Uint32.encode(stream, encodedLedgerHeader.baseFee);
        Uint32.encode(stream, encodedLedgerHeader.baseReserve);
        Uint32.encode(stream, encodedLedgerHeader.maxTxSetSize);
        int skipListsize = encodedLedgerHeader.getSkipList().length;
        for (int i = 0; i < skipListsize; ++i) {
            Hash.encode(stream, encodedLedgerHeader.skipList[i]);
        }
        LedgerHeaderExt.encode(stream, encodedLedgerHeader.ext);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        LedgerHeader.encode(stream, this);
    }

    public static LedgerHeader decode(XdrDataInputStream stream) throws IOException {
        LedgerHeader decodedLedgerHeader = new LedgerHeader();
        decodedLedgerHeader.ledgerVersion = Uint32.decode(stream);
        decodedLedgerHeader.previousLedgerHash = Hash.decode(stream);
        decodedLedgerHeader.scpValue = StellarValue.decode(stream);
        decodedLedgerHeader.txSetResultHash = Hash.decode(stream);
        decodedLedgerHeader.bucketListHash = Hash.decode(stream);
        decodedLedgerHeader.ledgerSeq = Uint32.decode(stream);
        decodedLedgerHeader.totalCoins = Int64.decode(stream);
        decodedLedgerHeader.feePool = Int64.decode(stream);
        decodedLedgerHeader.inflationSeq = Uint32.decode(stream);
        decodedLedgerHeader.idPool = Uint64.decode(stream);
        decodedLedgerHeader.baseFee = Uint32.decode(stream);
        decodedLedgerHeader.baseReserve = Uint32.decode(stream);
        decodedLedgerHeader.maxTxSetSize = Uint32.decode(stream);
        int skipListsize = 4;
        decodedLedgerHeader.skipList = new Hash[skipListsize];
        for (int i = 0; i < skipListsize; ++i) {
            decodedLedgerHeader.skipList[i] = Hash.decode(stream);
        }
        decodedLedgerHeader.ext = LedgerHeaderExt.decode(stream);
        return decodedLedgerHeader;
    }

    public int hashCode() {
        return Objects.hashCode(this.ledgerVersion, this.previousLedgerHash, this.scpValue, this.txSetResultHash, this.bucketListHash, this.ledgerSeq, this.totalCoins, this.feePool, this.inflationSeq, this.idPool, this.baseFee, this.baseReserve, this.maxTxSetSize, Arrays.hashCode(this.skipList), this.ext);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof LedgerHeader)) {
            return false;
        }
        LedgerHeader other = (LedgerHeader)object;
        return Objects.equal(this.ledgerVersion, other.ledgerVersion) && Objects.equal(this.previousLedgerHash, other.previousLedgerHash) && Objects.equal(this.scpValue, other.scpValue) && Objects.equal(this.txSetResultHash, other.txSetResultHash) && Objects.equal(this.bucketListHash, other.bucketListHash) && Objects.equal(this.ledgerSeq, other.ledgerSeq) && Objects.equal(this.totalCoins, other.totalCoins) && Objects.equal(this.feePool, other.feePool) && Objects.equal(this.inflationSeq, other.inflationSeq) && Objects.equal(this.idPool, other.idPool) && Objects.equal(this.baseFee, other.baseFee) && Objects.equal(this.baseReserve, other.baseReserve) && Objects.equal(this.maxTxSetSize, other.maxTxSetSize) && Arrays.equals(this.skipList, other.skipList) && Objects.equal(this.ext, other.ext);
    }

    public static class LedgerHeaderExt {
        Integer v;

        public Integer getDiscriminant() {
            return this.v;
        }

        public void setDiscriminant(Integer value) {
            this.v = value;
        }

        public static void encode(XdrDataOutputStream stream, LedgerHeaderExt encodedLedgerHeaderExt) throws IOException {
            stream.writeInt(encodedLedgerHeaderExt.getDiscriminant());
            switch (encodedLedgerHeaderExt.getDiscriminant()) {
                default: 
            }
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            LedgerHeaderExt.encode(stream, this);
        }

        public static LedgerHeaderExt decode(XdrDataInputStream stream) throws IOException {
            LedgerHeaderExt decodedLedgerHeaderExt = new LedgerHeaderExt();
            Integer discriminant = stream.readInt();
            decodedLedgerHeaderExt.setDiscriminant(discriminant);
            switch (decodedLedgerHeaderExt.getDiscriminant()) {
                default: 
            }
            return decodedLedgerHeaderExt;
        }

        public int hashCode() {
            return Objects.hashCode(this.v);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof LedgerHeaderExt)) {
                return false;
            }
            LedgerHeaderExt other = (LedgerHeaderExt)object;
            return Objects.equal(this.v, other.v);
        }
    }
}

