/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.AccountEntry;
import org.stellar.sdk.xdr.ClaimableBalanceEntry;
import org.stellar.sdk.xdr.DataEntry;
import org.stellar.sdk.xdr.LedgerEntryExtensionV1;
import org.stellar.sdk.xdr.LedgerEntryType;
import org.stellar.sdk.xdr.OfferEntry;
import org.stellar.sdk.xdr.TrustLineEntry;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class LedgerEntry
implements XdrElement {
    private Uint32 lastModifiedLedgerSeq;
    private LedgerEntryData data;
    private LedgerEntryExt ext;

    public Uint32 getLastModifiedLedgerSeq() {
        return this.lastModifiedLedgerSeq;
    }

    public void setLastModifiedLedgerSeq(Uint32 value) {
        this.lastModifiedLedgerSeq = value;
    }

    public LedgerEntryData getData() {
        return this.data;
    }

    public void setData(LedgerEntryData value) {
        this.data = value;
    }

    public LedgerEntryExt getExt() {
        return this.ext;
    }

    public void setExt(LedgerEntryExt value) {
        this.ext = value;
    }

    public static void encode(XdrDataOutputStream stream, LedgerEntry encodedLedgerEntry) throws IOException {
        Uint32.encode(stream, encodedLedgerEntry.lastModifiedLedgerSeq);
        LedgerEntryData.encode(stream, encodedLedgerEntry.data);
        LedgerEntryExt.encode(stream, encodedLedgerEntry.ext);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        LedgerEntry.encode(stream, this);
    }

    public static LedgerEntry decode(XdrDataInputStream stream) throws IOException {
        LedgerEntry decodedLedgerEntry = new LedgerEntry();
        decodedLedgerEntry.lastModifiedLedgerSeq = Uint32.decode(stream);
        decodedLedgerEntry.data = LedgerEntryData.decode(stream);
        decodedLedgerEntry.ext = LedgerEntryExt.decode(stream);
        return decodedLedgerEntry;
    }

    public int hashCode() {
        return Objects.hashCode(this.lastModifiedLedgerSeq, this.data, this.ext);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof LedgerEntry)) {
            return false;
        }
        LedgerEntry other = (LedgerEntry)object;
        return Objects.equal(this.lastModifiedLedgerSeq, other.lastModifiedLedgerSeq) && Objects.equal(this.data, other.data) && Objects.equal(this.ext, other.ext);
    }

    public static class LedgerEntryExt {
        Integer v;
        private LedgerEntryExtensionV1 v1;

        public Integer getDiscriminant() {
            return this.v;
        }

        public void setDiscriminant(Integer value) {
            this.v = value;
        }

        public LedgerEntryExtensionV1 getV1() {
            return this.v1;
        }

        public void setV1(LedgerEntryExtensionV1 value) {
            this.v1 = value;
        }

        public static void encode(XdrDataOutputStream stream, LedgerEntryExt encodedLedgerEntryExt) throws IOException {
            stream.writeInt(encodedLedgerEntryExt.getDiscriminant());
            switch (encodedLedgerEntryExt.getDiscriminant()) {
                case 0: {
                    break;
                }
                case 1: {
                    LedgerEntryExtensionV1.encode(stream, encodedLedgerEntryExt.v1);
                }
            }
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            LedgerEntryExt.encode(stream, this);
        }

        public static LedgerEntryExt decode(XdrDataInputStream stream) throws IOException {
            LedgerEntryExt decodedLedgerEntryExt = new LedgerEntryExt();
            Integer discriminant = stream.readInt();
            decodedLedgerEntryExt.setDiscriminant(discriminant);
            switch (decodedLedgerEntryExt.getDiscriminant()) {
                case 0: {
                    break;
                }
                case 1: {
                    decodedLedgerEntryExt.v1 = LedgerEntryExtensionV1.decode(stream);
                }
            }
            return decodedLedgerEntryExt;
        }

        public int hashCode() {
            return Objects.hashCode(this.v1, this.v);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof LedgerEntryExt)) {
                return false;
            }
            LedgerEntryExt other = (LedgerEntryExt)object;
            return Objects.equal(this.v1, other.v1) && Objects.equal(this.v, other.v);
        }
    }

    public static class LedgerEntryData {
        LedgerEntryType type;
        private AccountEntry account;
        private TrustLineEntry trustLine;
        private OfferEntry offer;
        private DataEntry data;
        private ClaimableBalanceEntry claimableBalance;

        public LedgerEntryType getDiscriminant() {
            return this.type;
        }

        public void setDiscriminant(LedgerEntryType value) {
            this.type = value;
        }

        public AccountEntry getAccount() {
            return this.account;
        }

        public void setAccount(AccountEntry value) {
            this.account = value;
        }

        public TrustLineEntry getTrustLine() {
            return this.trustLine;
        }

        public void setTrustLine(TrustLineEntry value) {
            this.trustLine = value;
        }

        public OfferEntry getOffer() {
            return this.offer;
        }

        public void setOffer(OfferEntry value) {
            this.offer = value;
        }

        public DataEntry getData() {
            return this.data;
        }

        public void setData(DataEntry value) {
            this.data = value;
        }

        public ClaimableBalanceEntry getClaimableBalance() {
            return this.claimableBalance;
        }

        public void setClaimableBalance(ClaimableBalanceEntry value) {
            this.claimableBalance = value;
        }

        public static void encode(XdrDataOutputStream stream, LedgerEntryData encodedLedgerEntryData) throws IOException {
            stream.writeInt(encodedLedgerEntryData.getDiscriminant().getValue());
            switch (encodedLedgerEntryData.getDiscriminant()) {
                case ACCOUNT: {
                    AccountEntry.encode(stream, encodedLedgerEntryData.account);
                    break;
                }
                case TRUSTLINE: {
                    TrustLineEntry.encode(stream, encodedLedgerEntryData.trustLine);
                    break;
                }
                case OFFER: {
                    OfferEntry.encode(stream, encodedLedgerEntryData.offer);
                    break;
                }
                case DATA: {
                    DataEntry.encode(stream, encodedLedgerEntryData.data);
                    break;
                }
                case CLAIMABLE_BALANCE: {
                    ClaimableBalanceEntry.encode(stream, encodedLedgerEntryData.claimableBalance);
                }
            }
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            LedgerEntryData.encode(stream, this);
        }

        public static LedgerEntryData decode(XdrDataInputStream stream) throws IOException {
            LedgerEntryData decodedLedgerEntryData = new LedgerEntryData();
            LedgerEntryType discriminant = LedgerEntryType.decode(stream);
            decodedLedgerEntryData.setDiscriminant(discriminant);
            switch (decodedLedgerEntryData.getDiscriminant()) {
                case ACCOUNT: {
                    decodedLedgerEntryData.account = AccountEntry.decode(stream);
                    break;
                }
                case TRUSTLINE: {
                    decodedLedgerEntryData.trustLine = TrustLineEntry.decode(stream);
                    break;
                }
                case OFFER: {
                    decodedLedgerEntryData.offer = OfferEntry.decode(stream);
                    break;
                }
                case DATA: {
                    decodedLedgerEntryData.data = DataEntry.decode(stream);
                    break;
                }
                case CLAIMABLE_BALANCE: {
                    decodedLedgerEntryData.claimableBalance = ClaimableBalanceEntry.decode(stream);
                }
            }
            return decodedLedgerEntryData;
        }

        public int hashCode() {
            return Objects.hashCode(this.account, this.trustLine, this.offer, this.data, this.claimableBalance, this.type);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof LedgerEntryData)) {
                return false;
            }
            LedgerEntryData other = (LedgerEntryData)object;
            return Objects.equal(this.account, other.account) && Objects.equal(this.trustLine, other.trustLine) && Objects.equal(this.offer, other.offer) && Objects.equal(this.data, other.data) && Objects.equal(this.claimableBalance, other.claimableBalance) && Objects.equal(this.type, other.type);
        }
    }
}

