/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import java.util.Arrays;
import org.stellar.sdk.xdr.LedgerHeaderHistoryEntry;
import org.stellar.sdk.xdr.SCPHistoryEntry;
import org.stellar.sdk.xdr.TransactionResultMeta;
import org.stellar.sdk.xdr.TransactionSet;
import org.stellar.sdk.xdr.UpgradeEntryMeta;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class LedgerCloseMetaV0
implements XdrElement {
    private LedgerHeaderHistoryEntry ledgerHeader;
    private TransactionSet txSet;
    private TransactionResultMeta[] txProcessing;
    private UpgradeEntryMeta[] upgradesProcessing;
    private SCPHistoryEntry[] scpInfo;

    public LedgerHeaderHistoryEntry getLedgerHeader() {
        return this.ledgerHeader;
    }

    public void setLedgerHeader(LedgerHeaderHistoryEntry value) {
        this.ledgerHeader = value;
    }

    public TransactionSet getTxSet() {
        return this.txSet;
    }

    public void setTxSet(TransactionSet value) {
        this.txSet = value;
    }

    public TransactionResultMeta[] getTxProcessing() {
        return this.txProcessing;
    }

    public void setTxProcessing(TransactionResultMeta[] value) {
        this.txProcessing = value;
    }

    public UpgradeEntryMeta[] getUpgradesProcessing() {
        return this.upgradesProcessing;
    }

    public void setUpgradesProcessing(UpgradeEntryMeta[] value) {
        this.upgradesProcessing = value;
    }

    public SCPHistoryEntry[] getScpInfo() {
        return this.scpInfo;
    }

    public void setScpInfo(SCPHistoryEntry[] value) {
        this.scpInfo = value;
    }

    public static void encode(XdrDataOutputStream stream, LedgerCloseMetaV0 encodedLedgerCloseMetaV0) throws IOException {
        LedgerHeaderHistoryEntry.encode(stream, encodedLedgerCloseMetaV0.ledgerHeader);
        TransactionSet.encode(stream, encodedLedgerCloseMetaV0.txSet);
        int txProcessingsize = encodedLedgerCloseMetaV0.getTxProcessing().length;
        stream.writeInt(txProcessingsize);
        for (int i = 0; i < txProcessingsize; ++i) {
            TransactionResultMeta.encode(stream, encodedLedgerCloseMetaV0.txProcessing[i]);
        }
        int upgradesProcessingsize = encodedLedgerCloseMetaV0.getUpgradesProcessing().length;
        stream.writeInt(upgradesProcessingsize);
        for (int i = 0; i < upgradesProcessingsize; ++i) {
            UpgradeEntryMeta.encode(stream, encodedLedgerCloseMetaV0.upgradesProcessing[i]);
        }
        int scpInfosize = encodedLedgerCloseMetaV0.getScpInfo().length;
        stream.writeInt(scpInfosize);
        for (int i = 0; i < scpInfosize; ++i) {
            SCPHistoryEntry.encode(stream, encodedLedgerCloseMetaV0.scpInfo[i]);
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        LedgerCloseMetaV0.encode(stream, this);
    }

    public static LedgerCloseMetaV0 decode(XdrDataInputStream stream) throws IOException {
        LedgerCloseMetaV0 decodedLedgerCloseMetaV0 = new LedgerCloseMetaV0();
        decodedLedgerCloseMetaV0.ledgerHeader = LedgerHeaderHistoryEntry.decode(stream);
        decodedLedgerCloseMetaV0.txSet = TransactionSet.decode(stream);
        int txProcessingsize = stream.readInt();
        decodedLedgerCloseMetaV0.txProcessing = new TransactionResultMeta[txProcessingsize];
        for (int i = 0; i < txProcessingsize; ++i) {
            decodedLedgerCloseMetaV0.txProcessing[i] = TransactionResultMeta.decode(stream);
        }
        int upgradesProcessingsize = stream.readInt();
        decodedLedgerCloseMetaV0.upgradesProcessing = new UpgradeEntryMeta[upgradesProcessingsize];
        for (int i = 0; i < upgradesProcessingsize; ++i) {
            decodedLedgerCloseMetaV0.upgradesProcessing[i] = UpgradeEntryMeta.decode(stream);
        }
        int scpInfosize = stream.readInt();
        decodedLedgerCloseMetaV0.scpInfo = new SCPHistoryEntry[scpInfosize];
        for (int i = 0; i < scpInfosize; ++i) {
            decodedLedgerCloseMetaV0.scpInfo[i] = SCPHistoryEntry.decode(stream);
        }
        return decodedLedgerCloseMetaV0;
    }

    public int hashCode() {
        return Objects.hashCode(this.ledgerHeader, this.txSet, Arrays.hashCode(this.txProcessing), Arrays.hashCode(this.upgradesProcessing), Arrays.hashCode(this.scpInfo));
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof LedgerCloseMetaV0)) {
            return false;
        }
        LedgerCloseMetaV0 other = (LedgerCloseMetaV0)object;
        return Objects.equal(this.ledgerHeader, other.ledgerHeader) && Objects.equal(this.txSet, other.txSet) && Arrays.equals(this.txProcessing, other.txProcessing) && Arrays.equals(this.upgradesProcessing, other.upgradesProcessing) && Arrays.equals(this.scpInfo, other.scpInfo);
    }
}

