/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import java.util.Arrays;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.OperationResult;
import org.stellar.sdk.xdr.TransactionResultCode;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class InnerTransactionResult
implements XdrElement {
    private Int64 feeCharged;
    private InnerTransactionResultResult result;
    private InnerTransactionResultExt ext;

    public Int64 getFeeCharged() {
        return this.feeCharged;
    }

    public void setFeeCharged(Int64 value) {
        this.feeCharged = value;
    }

    public InnerTransactionResultResult getResult() {
        return this.result;
    }

    public void setResult(InnerTransactionResultResult value) {
        this.result = value;
    }

    public InnerTransactionResultExt getExt() {
        return this.ext;
    }

    public void setExt(InnerTransactionResultExt value) {
        this.ext = value;
    }

    public static void encode(XdrDataOutputStream stream, InnerTransactionResult encodedInnerTransactionResult) throws IOException {
        Int64.encode(stream, encodedInnerTransactionResult.feeCharged);
        InnerTransactionResultResult.encode(stream, encodedInnerTransactionResult.result);
        InnerTransactionResultExt.encode(stream, encodedInnerTransactionResult.ext);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        InnerTransactionResult.encode(stream, this);
    }

    public static InnerTransactionResult decode(XdrDataInputStream stream) throws IOException {
        InnerTransactionResult decodedInnerTransactionResult = new InnerTransactionResult();
        decodedInnerTransactionResult.feeCharged = Int64.decode(stream);
        decodedInnerTransactionResult.result = InnerTransactionResultResult.decode(stream);
        decodedInnerTransactionResult.ext = InnerTransactionResultExt.decode(stream);
        return decodedInnerTransactionResult;
    }

    public int hashCode() {
        return Objects.hashCode(this.feeCharged, this.result, this.ext);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof InnerTransactionResult)) {
            return false;
        }
        InnerTransactionResult other = (InnerTransactionResult)object;
        return Objects.equal(this.feeCharged, other.feeCharged) && Objects.equal(this.result, other.result) && Objects.equal(this.ext, other.ext);
    }

    public static class InnerTransactionResultExt {
        Integer v;

        public Integer getDiscriminant() {
            return this.v;
        }

        public void setDiscriminant(Integer value) {
            this.v = value;
        }

        public static void encode(XdrDataOutputStream stream, InnerTransactionResultExt encodedInnerTransactionResultExt) throws IOException {
            stream.writeInt(encodedInnerTransactionResultExt.getDiscriminant());
            switch (encodedInnerTransactionResultExt.getDiscriminant()) {
                default: 
            }
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            InnerTransactionResultExt.encode(stream, this);
        }

        public static InnerTransactionResultExt decode(XdrDataInputStream stream) throws IOException {
            InnerTransactionResultExt decodedInnerTransactionResultExt = new InnerTransactionResultExt();
            Integer discriminant = stream.readInt();
            decodedInnerTransactionResultExt.setDiscriminant(discriminant);
            switch (decodedInnerTransactionResultExt.getDiscriminant()) {
                default: 
            }
            return decodedInnerTransactionResultExt;
        }

        public int hashCode() {
            return Objects.hashCode(this.v);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof InnerTransactionResultExt)) {
                return false;
            }
            InnerTransactionResultExt other = (InnerTransactionResultExt)object;
            return Objects.equal(this.v, other.v);
        }
    }

    public static class InnerTransactionResultResult {
        TransactionResultCode code;
        private OperationResult[] results;

        public TransactionResultCode getDiscriminant() {
            return this.code;
        }

        public void setDiscriminant(TransactionResultCode value) {
            this.code = value;
        }

        public OperationResult[] getResults() {
            return this.results;
        }

        public void setResults(OperationResult[] value) {
            this.results = value;
        }

        public static void encode(XdrDataOutputStream stream, InnerTransactionResultResult encodedInnerTransactionResultResult) throws IOException {
            stream.writeInt(encodedInnerTransactionResultResult.getDiscriminant().getValue());
            switch (encodedInnerTransactionResultResult.getDiscriminant()) {
                case txSUCCESS: 
                case txFAILED: {
                    int resultssize = encodedInnerTransactionResultResult.getResults().length;
                    stream.writeInt(resultssize);
                    for (int i = 0; i < resultssize; ++i) {
                        OperationResult.encode(stream, encodedInnerTransactionResultResult.results[i]);
                    }
                    break;
                }
            }
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            InnerTransactionResultResult.encode(stream, this);
        }

        public static InnerTransactionResultResult decode(XdrDataInputStream stream) throws IOException {
            InnerTransactionResultResult decodedInnerTransactionResultResult = new InnerTransactionResultResult();
            TransactionResultCode discriminant = TransactionResultCode.decode(stream);
            decodedInnerTransactionResultResult.setDiscriminant(discriminant);
            switch (decodedInnerTransactionResultResult.getDiscriminant()) {
                case txSUCCESS: 
                case txFAILED: {
                    int resultssize = stream.readInt();
                    decodedInnerTransactionResultResult.results = new OperationResult[resultssize];
                    for (int i = 0; i < resultssize; ++i) {
                        decodedInnerTransactionResultResult.results[i] = OperationResult.decode(stream);
                    }
                    break;
                }
            }
            return decodedInnerTransactionResultResult;
        }

        public int hashCode() {
            return Objects.hashCode(Arrays.hashCode(this.results), this.code);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof InnerTransactionResultResult)) {
                return false;
            }
            InnerTransactionResultResult other = (InnerTransactionResultResult)object;
            return Arrays.equals(this.results, other.results) && Objects.equal(this.code, other.code);
        }
    }
}

