/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import java.util.Arrays;
import org.stellar.sdk.xdr.InflationPayout;
import org.stellar.sdk.xdr.InflationResultCode;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class InflationResult
implements XdrElement {
    InflationResultCode code;
    private InflationPayout[] payouts;

    public InflationResultCode getDiscriminant() {
        return this.code;
    }

    public void setDiscriminant(InflationResultCode value) {
        this.code = value;
    }

    public InflationPayout[] getPayouts() {
        return this.payouts;
    }

    public void setPayouts(InflationPayout[] value) {
        this.payouts = value;
    }

    public static void encode(XdrDataOutputStream stream, InflationResult encodedInflationResult) throws IOException {
        stream.writeInt(encodedInflationResult.getDiscriminant().getValue());
        switch (encodedInflationResult.getDiscriminant()) {
            case INFLATION_SUCCESS: {
                int payoutssize = encodedInflationResult.getPayouts().length;
                stream.writeInt(payoutssize);
                for (int i = 0; i < payoutssize; ++i) {
                    InflationPayout.encode(stream, encodedInflationResult.payouts[i]);
                }
                break;
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        InflationResult.encode(stream, this);
    }

    public static InflationResult decode(XdrDataInputStream stream) throws IOException {
        InflationResult decodedInflationResult = new InflationResult();
        InflationResultCode discriminant = InflationResultCode.decode(stream);
        decodedInflationResult.setDiscriminant(discriminant);
        switch (decodedInflationResult.getDiscriminant()) {
            case INFLATION_SUCCESS: {
                int payoutssize = stream.readInt();
                decodedInflationResult.payouts = new InflationPayout[payoutssize];
                for (int i = 0; i < payoutssize; ++i) {
                    decodedInflationResult.payouts[i] = InflationPayout.decode(stream);
                }
                break;
            }
        }
        return decodedInflationResult;
    }

    public int hashCode() {
        return Objects.hashCode(Arrays.hashCode(this.payouts), this.code);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof InflationResult)) {
            return false;
        }
        InflationResult other = (InflationResult)object;
        return Arrays.equals(this.payouts, other.payouts) && Objects.equal(this.code, other.code);
    }
}

