/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum IPAddrType implements XdrElement
{
    IPv4(0),
    IPv6(1);

    private int mValue;

    private IPAddrType(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static IPAddrType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return IPv4;
            }
            case 1: {
                return IPv6;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, IPAddrType value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        IPAddrType.encode(stream, this);
    }
}

