/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import java.util.Arrays;
import org.stellar.sdk.xdr.DecoratedSignature;
import org.stellar.sdk.xdr.FeeBumpTransaction;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class FeeBumpTransactionEnvelope
implements XdrElement {
    private FeeBumpTransaction tx;
    private DecoratedSignature[] signatures;

    public FeeBumpTransaction getTx() {
        return this.tx;
    }

    public void setTx(FeeBumpTransaction value) {
        this.tx = value;
    }

    public DecoratedSignature[] getSignatures() {
        return this.signatures;
    }

    public void setSignatures(DecoratedSignature[] value) {
        this.signatures = value;
    }

    public static void encode(XdrDataOutputStream stream, FeeBumpTransactionEnvelope encodedFeeBumpTransactionEnvelope) throws IOException {
        FeeBumpTransaction.encode(stream, encodedFeeBumpTransactionEnvelope.tx);
        int signaturessize = encodedFeeBumpTransactionEnvelope.getSignatures().length;
        stream.writeInt(signaturessize);
        for (int i = 0; i < signaturessize; ++i) {
            DecoratedSignature.encode(stream, encodedFeeBumpTransactionEnvelope.signatures[i]);
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        FeeBumpTransactionEnvelope.encode(stream, this);
    }

    public static FeeBumpTransactionEnvelope decode(XdrDataInputStream stream) throws IOException {
        FeeBumpTransactionEnvelope decodedFeeBumpTransactionEnvelope = new FeeBumpTransactionEnvelope();
        decodedFeeBumpTransactionEnvelope.tx = FeeBumpTransaction.decode(stream);
        int signaturessize = stream.readInt();
        decodedFeeBumpTransactionEnvelope.signatures = new DecoratedSignature[signaturessize];
        for (int i = 0; i < signaturessize; ++i) {
            decodedFeeBumpTransactionEnvelope.signatures[i] = DecoratedSignature.decode(stream);
        }
        return decodedFeeBumpTransactionEnvelope;
    }

    public int hashCode() {
        return Objects.hashCode(this.tx, Arrays.hashCode(this.signatures));
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof FeeBumpTransactionEnvelope)) {
            return false;
        }
        FeeBumpTransactionEnvelope other = (FeeBumpTransactionEnvelope)object;
        return Objects.equal(this.tx, other.tx) && Arrays.equals(this.signatures, other.signatures);
    }
}

