/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum ErrorCode implements XdrElement
{
    ERR_MISC(0),
    ERR_DATA(1),
    ERR_CONF(2),
    ERR_AUTH(3),
    ERR_LOAD(4);

    private int mValue;

    private ErrorCode(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static ErrorCode decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return ERR_MISC;
            }
            case 1: {
                return ERR_DATA;
            }
            case 2: {
                return ERR_CONF;
            }
            case 3: {
                return ERR_AUTH;
            }
            case 4: {
                return ERR_LOAD;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, ErrorCode value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        ErrorCode.encode(stream, this);
    }
}

