/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import java.util.Arrays;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.Claimant;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class CreateClaimableBalanceOp
implements XdrElement {
    private Asset asset;
    private Int64 amount;
    private Claimant[] claimants;

    public Asset getAsset() {
        return this.asset;
    }

    public void setAsset(Asset value) {
        this.asset = value;
    }

    public Int64 getAmount() {
        return this.amount;
    }

    public void setAmount(Int64 value) {
        this.amount = value;
    }

    public Claimant[] getClaimants() {
        return this.claimants;
    }

    public void setClaimants(Claimant[] value) {
        this.claimants = value;
    }

    public static void encode(XdrDataOutputStream stream, CreateClaimableBalanceOp encodedCreateClaimableBalanceOp) throws IOException {
        Asset.encode(stream, encodedCreateClaimableBalanceOp.asset);
        Int64.encode(stream, encodedCreateClaimableBalanceOp.amount);
        int claimantssize = encodedCreateClaimableBalanceOp.getClaimants().length;
        stream.writeInt(claimantssize);
        for (int i = 0; i < claimantssize; ++i) {
            Claimant.encode(stream, encodedCreateClaimableBalanceOp.claimants[i]);
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        CreateClaimableBalanceOp.encode(stream, this);
    }

    public static CreateClaimableBalanceOp decode(XdrDataInputStream stream) throws IOException {
        CreateClaimableBalanceOp decodedCreateClaimableBalanceOp = new CreateClaimableBalanceOp();
        decodedCreateClaimableBalanceOp.asset = Asset.decode(stream);
        decodedCreateClaimableBalanceOp.amount = Int64.decode(stream);
        int claimantssize = stream.readInt();
        decodedCreateClaimableBalanceOp.claimants = new Claimant[claimantssize];
        for (int i = 0; i < claimantssize; ++i) {
            decodedCreateClaimableBalanceOp.claimants[i] = Claimant.decode(stream);
        }
        return decodedCreateClaimableBalanceOp;
    }

    public int hashCode() {
        return Objects.hashCode(this.asset, this.amount, Arrays.hashCode(this.claimants));
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof CreateClaimableBalanceOp)) {
            return false;
        }
        CreateClaimableBalanceOp other = (CreateClaimableBalanceOp)object;
        return Objects.equal(this.asset, other.asset) && Objects.equal(this.amount, other.amount) && Arrays.equals(this.claimants, other.claimants);
    }
}

