/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.ClaimPredicate;
import org.stellar.sdk.xdr.ClaimantType;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class Claimant
implements XdrElement {
    ClaimantType type;
    private ClaimantV0 v0;

    public ClaimantType getDiscriminant() {
        return this.type;
    }

    public void setDiscriminant(ClaimantType value) {
        this.type = value;
    }

    public ClaimantV0 getV0() {
        return this.v0;
    }

    public void setV0(ClaimantV0 value) {
        this.v0 = value;
    }

    public static void encode(XdrDataOutputStream stream, Claimant encodedClaimant) throws IOException {
        stream.writeInt(encodedClaimant.getDiscriminant().getValue());
        switch (encodedClaimant.getDiscriminant()) {
            case CLAIMANT_TYPE_V0: {
                ClaimantV0.encode(stream, encodedClaimant.v0);
            }
        }
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        Claimant.encode(stream, this);
    }

    public static Claimant decode(XdrDataInputStream stream) throws IOException {
        Claimant decodedClaimant = new Claimant();
        ClaimantType discriminant = ClaimantType.decode(stream);
        decodedClaimant.setDiscriminant(discriminant);
        switch (decodedClaimant.getDiscriminant()) {
            case CLAIMANT_TYPE_V0: {
                decodedClaimant.v0 = ClaimantV0.decode(stream);
            }
        }
        return decodedClaimant;
    }

    public int hashCode() {
        return Objects.hashCode(this.v0, this.type);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Claimant)) {
            return false;
        }
        Claimant other = (Claimant)object;
        return Objects.equal(this.v0, other.v0) && Objects.equal(this.type, other.type);
    }

    public static class ClaimantV0 {
        private AccountID destination;
        private ClaimPredicate predicate;

        public AccountID getDestination() {
            return this.destination;
        }

        public void setDestination(AccountID value) {
            this.destination = value;
        }

        public ClaimPredicate getPredicate() {
            return this.predicate;
        }

        public void setPredicate(ClaimPredicate value) {
            this.predicate = value;
        }

        public static void encode(XdrDataOutputStream stream, ClaimantV0 encodedClaimantV0) throws IOException {
            AccountID.encode(stream, encodedClaimantV0.destination);
            ClaimPredicate.encode(stream, encodedClaimantV0.predicate);
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            ClaimantV0.encode(stream, this);
        }

        public static ClaimantV0 decode(XdrDataInputStream stream) throws IOException {
            ClaimantV0 decodedClaimantV0 = new ClaimantV0();
            decodedClaimantV0.destination = AccountID.decode(stream);
            decodedClaimantV0.predicate = ClaimPredicate.decode(stream);
            return decodedClaimantV0;
        }

        public int hashCode() {
            return Objects.hashCode(this.destination, this.predicate);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof ClaimantV0)) {
                return false;
            }
            ClaimantV0 other = (ClaimantV0)object;
            return Objects.equal(this.destination, other.destination) && Objects.equal(this.predicate, other.predicate);
        }
    }
}

