/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import java.util.Arrays;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.ClaimableBalanceID;
import org.stellar.sdk.xdr.Claimant;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class ClaimableBalanceEntry
implements XdrElement {
    private ClaimableBalanceID balanceID;
    private Claimant[] claimants;
    private Asset asset;
    private Int64 amount;
    private ClaimableBalanceEntryExt ext;

    public ClaimableBalanceID getBalanceID() {
        return this.balanceID;
    }

    public void setBalanceID(ClaimableBalanceID value) {
        this.balanceID = value;
    }

    public Claimant[] getClaimants() {
        return this.claimants;
    }

    public void setClaimants(Claimant[] value) {
        this.claimants = value;
    }

    public Asset getAsset() {
        return this.asset;
    }

    public void setAsset(Asset value) {
        this.asset = value;
    }

    public Int64 getAmount() {
        return this.amount;
    }

    public void setAmount(Int64 value) {
        this.amount = value;
    }

    public ClaimableBalanceEntryExt getExt() {
        return this.ext;
    }

    public void setExt(ClaimableBalanceEntryExt value) {
        this.ext = value;
    }

    public static void encode(XdrDataOutputStream stream, ClaimableBalanceEntry encodedClaimableBalanceEntry) throws IOException {
        ClaimableBalanceID.encode(stream, encodedClaimableBalanceEntry.balanceID);
        int claimantssize = encodedClaimableBalanceEntry.getClaimants().length;
        stream.writeInt(claimantssize);
        for (int i = 0; i < claimantssize; ++i) {
            Claimant.encode(stream, encodedClaimableBalanceEntry.claimants[i]);
        }
        Asset.encode(stream, encodedClaimableBalanceEntry.asset);
        Int64.encode(stream, encodedClaimableBalanceEntry.amount);
        ClaimableBalanceEntryExt.encode(stream, encodedClaimableBalanceEntry.ext);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        ClaimableBalanceEntry.encode(stream, this);
    }

    public static ClaimableBalanceEntry decode(XdrDataInputStream stream) throws IOException {
        ClaimableBalanceEntry decodedClaimableBalanceEntry = new ClaimableBalanceEntry();
        decodedClaimableBalanceEntry.balanceID = ClaimableBalanceID.decode(stream);
        int claimantssize = stream.readInt();
        decodedClaimableBalanceEntry.claimants = new Claimant[claimantssize];
        for (int i = 0; i < claimantssize; ++i) {
            decodedClaimableBalanceEntry.claimants[i] = Claimant.decode(stream);
        }
        decodedClaimableBalanceEntry.asset = Asset.decode(stream);
        decodedClaimableBalanceEntry.amount = Int64.decode(stream);
        decodedClaimableBalanceEntry.ext = ClaimableBalanceEntryExt.decode(stream);
        return decodedClaimableBalanceEntry;
    }

    public int hashCode() {
        return Objects.hashCode(this.balanceID, Arrays.hashCode(this.claimants), this.asset, this.amount, this.ext);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ClaimableBalanceEntry)) {
            return false;
        }
        ClaimableBalanceEntry other = (ClaimableBalanceEntry)object;
        return Objects.equal(this.balanceID, other.balanceID) && Arrays.equals(this.claimants, other.claimants) && Objects.equal(this.asset, other.asset) && Objects.equal(this.amount, other.amount) && Objects.equal(this.ext, other.ext);
    }

    public static class ClaimableBalanceEntryExt {
        Integer v;

        public Integer getDiscriminant() {
            return this.v;
        }

        public void setDiscriminant(Integer value) {
            this.v = value;
        }

        public static void encode(XdrDataOutputStream stream, ClaimableBalanceEntryExt encodedClaimableBalanceEntryExt) throws IOException {
            stream.writeInt(encodedClaimableBalanceEntryExt.getDiscriminant());
            switch (encodedClaimableBalanceEntryExt.getDiscriminant()) {
                default: 
            }
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            ClaimableBalanceEntryExt.encode(stream, this);
        }

        public static ClaimableBalanceEntryExt decode(XdrDataInputStream stream) throws IOException {
            ClaimableBalanceEntryExt decodedClaimableBalanceEntryExt = new ClaimableBalanceEntryExt();
            Integer discriminant = stream.readInt();
            decodedClaimableBalanceEntryExt.setDiscriminant(discriminant);
            switch (decodedClaimableBalanceEntryExt.getDiscriminant()) {
                default: 
            }
            return decodedClaimableBalanceEntryExt;
        }

        public int hashCode() {
            return Objects.hashCode(this.v);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof ClaimableBalanceEntryExt)) {
                return false;
            }
            ClaimableBalanceEntryExt other = (ClaimableBalanceEntryExt)object;
            return Objects.equal(this.v, other.v);
        }
    }
}

