/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.Curve25519Public;
import org.stellar.sdk.xdr.Signature;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class AuthCert
implements XdrElement {
    private Curve25519Public pubkey;
    private Uint64 expiration;
    private Signature sig;

    public Curve25519Public getPubkey() {
        return this.pubkey;
    }

    public void setPubkey(Curve25519Public value) {
        this.pubkey = value;
    }

    public Uint64 getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Uint64 value) {
        this.expiration = value;
    }

    public Signature getSig() {
        return this.sig;
    }

    public void setSig(Signature value) {
        this.sig = value;
    }

    public static void encode(XdrDataOutputStream stream, AuthCert encodedAuthCert) throws IOException {
        Curve25519Public.encode(stream, encodedAuthCert.pubkey);
        Uint64.encode(stream, encodedAuthCert.expiration);
        Signature.encode(stream, encodedAuthCert.sig);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        AuthCert.encode(stream, this);
    }

    public static AuthCert decode(XdrDataInputStream stream) throws IOException {
        AuthCert decodedAuthCert = new AuthCert();
        decodedAuthCert.pubkey = Curve25519Public.decode(stream);
        decodedAuthCert.expiration = Uint64.decode(stream);
        decodedAuthCert.sig = Signature.decode(stream);
        return decodedAuthCert;
    }

    public int hashCode() {
        return Objects.hashCode(this.pubkey, this.expiration, this.sig);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AuthCert)) {
            return false;
        }
        AuthCert other = (AuthCert)object;
        return Objects.equal(this.pubkey, other.pubkey) && Objects.equal(this.expiration, other.expiration) && Objects.equal(this.sig, other.sig);
    }
}

