/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum AllowTrustResultCode implements XdrElement
{
    ALLOW_TRUST_SUCCESS(0),
    ALLOW_TRUST_MALFORMED(-1),
    ALLOW_TRUST_NO_TRUST_LINE(-2),
    ALLOW_TRUST_TRUST_NOT_REQUIRED(-3),
    ALLOW_TRUST_CANT_REVOKE(-4),
    ALLOW_TRUST_SELF_NOT_ALLOWED(-5);

    private int mValue;

    private AllowTrustResultCode(int value) {
        this.mValue = value;
    }

    public int getValue() {
        return this.mValue;
    }

    public static AllowTrustResultCode decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return ALLOW_TRUST_SUCCESS;
            }
            case -1: {
                return ALLOW_TRUST_MALFORMED;
            }
            case -2: {
                return ALLOW_TRUST_NO_TRUST_LINE;
            }
            case -3: {
                return ALLOW_TRUST_TRUST_NOT_REQUIRED;
            }
            case -4: {
                return ALLOW_TRUST_CANT_REVOKE;
            }
            case -5: {
                return ALLOW_TRUST_SELF_NOT_ALLOWED;
            }
        }
        throw new RuntimeException("Unknown enum value: " + value);
    }

    public static void encode(XdrDataOutputStream stream, AllowTrustResultCode value) throws IOException {
        stream.writeInt(value.getValue());
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        AllowTrustResultCode.encode(stream, this);
    }
}

