/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.AssetCode12;
import org.stellar.sdk.xdr.AssetCode4;
import org.stellar.sdk.xdr.AssetType;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class AllowTrustOp
implements XdrElement {
    private AccountID trustor;
    private AllowTrustOpAsset asset;
    private Uint32 authorize;

    public AccountID getTrustor() {
        return this.trustor;
    }

    public void setTrustor(AccountID value) {
        this.trustor = value;
    }

    public AllowTrustOpAsset getAsset() {
        return this.asset;
    }

    public void setAsset(AllowTrustOpAsset value) {
        this.asset = value;
    }

    public Uint32 getAuthorize() {
        return this.authorize;
    }

    public void setAuthorize(Uint32 value) {
        this.authorize = value;
    }

    public static void encode(XdrDataOutputStream stream, AllowTrustOp encodedAllowTrustOp) throws IOException {
        AccountID.encode(stream, encodedAllowTrustOp.trustor);
        AllowTrustOpAsset.encode(stream, encodedAllowTrustOp.asset);
        Uint32.encode(stream, encodedAllowTrustOp.authorize);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        AllowTrustOp.encode(stream, this);
    }

    public static AllowTrustOp decode(XdrDataInputStream stream) throws IOException {
        AllowTrustOp decodedAllowTrustOp = new AllowTrustOp();
        decodedAllowTrustOp.trustor = AccountID.decode(stream);
        decodedAllowTrustOp.asset = AllowTrustOpAsset.decode(stream);
        decodedAllowTrustOp.authorize = Uint32.decode(stream);
        return decodedAllowTrustOp;
    }

    public int hashCode() {
        return Objects.hashCode(this.trustor, this.asset, this.authorize);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AllowTrustOp)) {
            return false;
        }
        AllowTrustOp other = (AllowTrustOp)object;
        return Objects.equal(this.trustor, other.trustor) && Objects.equal(this.asset, other.asset) && Objects.equal(this.authorize, other.authorize);
    }

    public static class AllowTrustOpAsset {
        AssetType type;
        private AssetCode4 assetCode4;
        private AssetCode12 assetCode12;

        public AssetType getDiscriminant() {
            return this.type;
        }

        public void setDiscriminant(AssetType value) {
            this.type = value;
        }

        public AssetCode4 getAssetCode4() {
            return this.assetCode4;
        }

        public void setAssetCode4(AssetCode4 value) {
            this.assetCode4 = value;
        }

        public AssetCode12 getAssetCode12() {
            return this.assetCode12;
        }

        public void setAssetCode12(AssetCode12 value) {
            this.assetCode12 = value;
        }

        public static void encode(XdrDataOutputStream stream, AllowTrustOpAsset encodedAllowTrustOpAsset) throws IOException {
            stream.writeInt(encodedAllowTrustOpAsset.getDiscriminant().getValue());
            switch (encodedAllowTrustOpAsset.getDiscriminant()) {
                case ASSET_TYPE_CREDIT_ALPHANUM4: {
                    AssetCode4.encode(stream, encodedAllowTrustOpAsset.assetCode4);
                    break;
                }
                case ASSET_TYPE_CREDIT_ALPHANUM12: {
                    AssetCode12.encode(stream, encodedAllowTrustOpAsset.assetCode12);
                }
            }
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            AllowTrustOpAsset.encode(stream, this);
        }

        public static AllowTrustOpAsset decode(XdrDataInputStream stream) throws IOException {
            AllowTrustOpAsset decodedAllowTrustOpAsset = new AllowTrustOpAsset();
            AssetType discriminant = AssetType.decode(stream);
            decodedAllowTrustOpAsset.setDiscriminant(discriminant);
            switch (decodedAllowTrustOpAsset.getDiscriminant()) {
                case ASSET_TYPE_CREDIT_ALPHANUM4: {
                    decodedAllowTrustOpAsset.assetCode4 = AssetCode4.decode(stream);
                    break;
                }
                case ASSET_TYPE_CREDIT_ALPHANUM12: {
                    decodedAllowTrustOpAsset.assetCode12 = AssetCode12.decode(stream);
                }
            }
            return decodedAllowTrustOpAsset;
        }

        public int hashCode() {
            return Objects.hashCode(this.assetCode4, this.assetCode12, this.type);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof AllowTrustOpAsset)) {
                return false;
            }
            AllowTrustOpAsset other = (AllowTrustOpAsset)object;
            return Objects.equal(this.assetCode4, other.assetCode4) && Objects.equal(this.assetCode12, other.assetCode12) && Objects.equal(this.type, other.type);
        }
    }
}

