/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.IOException;
import java.util.Arrays;
import org.stellar.sdk.xdr.AccountEntryExtensionV1;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.SequenceNumber;
import org.stellar.sdk.xdr.Signer;
import org.stellar.sdk.xdr.String32;
import org.stellar.sdk.xdr.Thresholds;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import shadow.com.google.common.base.Objects;

public class AccountEntry
implements XdrElement {
    private AccountID accountID;
    private Int64 balance;
    private SequenceNumber seqNum;
    private Uint32 numSubEntries;
    private AccountID inflationDest;
    private Uint32 flags;
    private String32 homeDomain;
    private Thresholds thresholds;
    private Signer[] signers;
    private AccountEntryExt ext;

    public AccountID getAccountID() {
        return this.accountID;
    }

    public void setAccountID(AccountID value) {
        this.accountID = value;
    }

    public Int64 getBalance() {
        return this.balance;
    }

    public void setBalance(Int64 value) {
        this.balance = value;
    }

    public SequenceNumber getSeqNum() {
        return this.seqNum;
    }

    public void setSeqNum(SequenceNumber value) {
        this.seqNum = value;
    }

    public Uint32 getNumSubEntries() {
        return this.numSubEntries;
    }

    public void setNumSubEntries(Uint32 value) {
        this.numSubEntries = value;
    }

    public AccountID getInflationDest() {
        return this.inflationDest;
    }

    public void setInflationDest(AccountID value) {
        this.inflationDest = value;
    }

    public Uint32 getFlags() {
        return this.flags;
    }

    public void setFlags(Uint32 value) {
        this.flags = value;
    }

    public String32 getHomeDomain() {
        return this.homeDomain;
    }

    public void setHomeDomain(String32 value) {
        this.homeDomain = value;
    }

    public Thresholds getThresholds() {
        return this.thresholds;
    }

    public void setThresholds(Thresholds value) {
        this.thresholds = value;
    }

    public Signer[] getSigners() {
        return this.signers;
    }

    public void setSigners(Signer[] value) {
        this.signers = value;
    }

    public AccountEntryExt getExt() {
        return this.ext;
    }

    public void setExt(AccountEntryExt value) {
        this.ext = value;
    }

    public static void encode(XdrDataOutputStream stream, AccountEntry encodedAccountEntry) throws IOException {
        AccountID.encode(stream, encodedAccountEntry.accountID);
        Int64.encode(stream, encodedAccountEntry.balance);
        SequenceNumber.encode(stream, encodedAccountEntry.seqNum);
        Uint32.encode(stream, encodedAccountEntry.numSubEntries);
        if (encodedAccountEntry.inflationDest != null) {
            stream.writeInt(1);
            AccountID.encode(stream, encodedAccountEntry.inflationDest);
        } else {
            stream.writeInt(0);
        }
        Uint32.encode(stream, encodedAccountEntry.flags);
        String32.encode(stream, encodedAccountEntry.homeDomain);
        Thresholds.encode(stream, encodedAccountEntry.thresholds);
        int signerssize = encodedAccountEntry.getSigners().length;
        stream.writeInt(signerssize);
        for (int i = 0; i < signerssize; ++i) {
            Signer.encode(stream, encodedAccountEntry.signers[i]);
        }
        AccountEntryExt.encode(stream, encodedAccountEntry.ext);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        AccountEntry.encode(stream, this);
    }

    public static AccountEntry decode(XdrDataInputStream stream) throws IOException {
        AccountEntry decodedAccountEntry = new AccountEntry();
        decodedAccountEntry.accountID = AccountID.decode(stream);
        decodedAccountEntry.balance = Int64.decode(stream);
        decodedAccountEntry.seqNum = SequenceNumber.decode(stream);
        decodedAccountEntry.numSubEntries = Uint32.decode(stream);
        int inflationDestPresent = stream.readInt();
        if (inflationDestPresent != 0) {
            decodedAccountEntry.inflationDest = AccountID.decode(stream);
        }
        decodedAccountEntry.flags = Uint32.decode(stream);
        decodedAccountEntry.homeDomain = String32.decode(stream);
        decodedAccountEntry.thresholds = Thresholds.decode(stream);
        int signerssize = stream.readInt();
        decodedAccountEntry.signers = new Signer[signerssize];
        for (int i = 0; i < signerssize; ++i) {
            decodedAccountEntry.signers[i] = Signer.decode(stream);
        }
        decodedAccountEntry.ext = AccountEntryExt.decode(stream);
        return decodedAccountEntry;
    }

    public int hashCode() {
        return Objects.hashCode(this.accountID, this.balance, this.seqNum, this.numSubEntries, this.inflationDest, this.flags, this.homeDomain, this.thresholds, Arrays.hashCode(this.signers), this.ext);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AccountEntry)) {
            return false;
        }
        AccountEntry other = (AccountEntry)object;
        return Objects.equal(this.accountID, other.accountID) && Objects.equal(this.balance, other.balance) && Objects.equal(this.seqNum, other.seqNum) && Objects.equal(this.numSubEntries, other.numSubEntries) && Objects.equal(this.inflationDest, other.inflationDest) && Objects.equal(this.flags, other.flags) && Objects.equal(this.homeDomain, other.homeDomain) && Objects.equal(this.thresholds, other.thresholds) && Arrays.equals(this.signers, other.signers) && Objects.equal(this.ext, other.ext);
    }

    public static class AccountEntryExt {
        Integer v;
        private AccountEntryExtensionV1 v1;

        public Integer getDiscriminant() {
            return this.v;
        }

        public void setDiscriminant(Integer value) {
            this.v = value;
        }

        public AccountEntryExtensionV1 getV1() {
            return this.v1;
        }

        public void setV1(AccountEntryExtensionV1 value) {
            this.v1 = value;
        }

        public static void encode(XdrDataOutputStream stream, AccountEntryExt encodedAccountEntryExt) throws IOException {
            stream.writeInt(encodedAccountEntryExt.getDiscriminant());
            switch (encodedAccountEntryExt.getDiscriminant()) {
                case 0: {
                    break;
                }
                case 1: {
                    AccountEntryExtensionV1.encode(stream, encodedAccountEntryExt.v1);
                }
            }
        }

        public void encode(XdrDataOutputStream stream) throws IOException {
            AccountEntryExt.encode(stream, this);
        }

        public static AccountEntryExt decode(XdrDataInputStream stream) throws IOException {
            AccountEntryExt decodedAccountEntryExt = new AccountEntryExt();
            Integer discriminant = stream.readInt();
            decodedAccountEntryExt.setDiscriminant(discriminant);
            switch (decodedAccountEntryExt.getDiscriminant()) {
                case 0: {
                    break;
                }
                case 1: {
                    decodedAccountEntryExt.v1 = AccountEntryExtensionV1.decode(stream);
                }
            }
            return decodedAccountEntryExt;
        }

        public int hashCode() {
            return Objects.hashCode(this.v1, this.v);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof AccountEntryExt)) {
                return false;
            }
            AccountEntryExt other = (AccountEntryExt)object;
            return Objects.equal(this.v1, other.v1) && Objects.equal(this.v, other.v);
        }
    }
}

