/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses.operations;

import java.util.List;
import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeNative;
import org.stellar.sdk.responses.operations.OperationResponse;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.gson.annotations.SerializedName;

public abstract class PathPaymentBaseOperationResponse
extends OperationResponse {
    @SerializedName(value="amount")
    protected final String amount;
    @SerializedName(value="source_amount")
    protected final String sourceAmount;
    @SerializedName(value="from")
    protected final String from;
    @SerializedName(value="to")
    protected final String to;
    @SerializedName(value="asset_type")
    protected final String assetType;
    @SerializedName(value="asset_code")
    protected final String assetCode;
    @SerializedName(value="asset_issuer")
    protected final String assetIssuer;
    @SerializedName(value="source_asset_type")
    protected final String sourceAssetType;
    @SerializedName(value="source_asset_code")
    protected final String sourceAssetCode;
    @SerializedName(value="source_asset_issuer")
    protected final String sourceAssetIssuer;
    @SerializedName(value="path")
    protected final List<Asset> path;

    public PathPaymentBaseOperationResponse(String amount, String sourceAmount, String from, String to, String assetType, String assetCode, String assetIssuer, String sourceAssetType, String sourceAssetCode, String sourceAssetIssuer, List<Asset> path) {
        this.amount = amount;
        this.sourceAmount = sourceAmount;
        this.from = from;
        this.to = to;
        this.assetType = assetType;
        this.assetCode = assetCode;
        this.assetIssuer = assetIssuer;
        this.sourceAssetType = sourceAssetType;
        this.sourceAssetCode = sourceAssetCode;
        this.sourceAssetIssuer = sourceAssetIssuer;
        this.path = ImmutableList.copyOf(path);
    }

    public String getAmount() {
        return this.amount;
    }

    public String getSourceAmount() {
        return this.sourceAmount;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public List<Asset> getPath() {
        return this.path;
    }

    public Asset getAsset() {
        if (this.assetType.equals("native")) {
            return new AssetTypeNative();
        }
        return Asset.createNonNativeAsset(this.assetCode, this.assetIssuer);
    }

    public Asset getSourceAsset() {
        if (this.sourceAssetType.equals("native")) {
            return new AssetTypeNative();
        }
        return Asset.createNonNativeAsset(this.sourceAssetCode, this.sourceAssetIssuer);
    }
}

