/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses.operations;

import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeNative;
import org.stellar.sdk.responses.operations.OperationResponse;
import shadow.com.google.gson.annotations.SerializedName;

public class ChangeTrustOperationResponse
extends OperationResponse {
    @SerializedName(value="trustor")
    protected final String trustor;
    @SerializedName(value="trustee")
    protected final String trustee;
    @SerializedName(value="asset_type")
    protected final String assetType;
    @SerializedName(value="asset_code")
    protected final String assetCode;
    @SerializedName(value="asset_issuer")
    protected final String assetIssuer;
    @SerializedName(value="limit")
    protected final String limit;

    ChangeTrustOperationResponse(String trustor, String trustee, String assetType, String assetCode, String assetIssuer, String limit) {
        this.trustor = trustor;
        this.trustee = trustee;
        this.assetType = assetType;
        this.assetCode = assetCode;
        this.assetIssuer = assetIssuer;
        this.limit = limit;
    }

    public String getTrustor() {
        return this.trustor;
    }

    public String getTrustee() {
        return this.trustee;
    }

    public String getLimit() {
        return this.limit;
    }

    public Asset getAsset() {
        if (this.assetType.equals("native")) {
            return new AssetTypeNative();
        }
        return Asset.createNonNativeAsset(this.assetCode, this.assetIssuer);
    }
}

